/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.shared.generated.dmo.PrimitiveSVDMO;
import org.dmd.dmt.shared.generated.types.DmcTypePrimitiveSVREF;

public class DmcTypePrimitiveSVREFSET
extends DmcTypePrimitiveSVREF
implements Serializable {
    private static final Iterator<PrimitiveSVDMO> emptyList = new HashSet().iterator();
    protected Set<PrimitiveSVDMO> value;

    public DmcTypePrimitiveSVREFSET() {
        this.value = null;
    }

    public DmcTypePrimitiveSVREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<PrimitiveSVDMO>() : new TreeSet<PrimitiveSVDMO>();
    }

    public DmcTypePrimitiveSVREFSET getNew() {
        return new DmcTypePrimitiveSVREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<PrimitiveSVDMO> cloneIt() {
        DmcTypePrimitiveSVREFSET dmcTypePrimitiveSVREFSET = this;
        synchronized (dmcTypePrimitiveSVREFSET) {
            DmcTypePrimitiveSVREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (PrimitiveSVDMO val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrimitiveSVDMO add(Object v) throws DmcValueException {
        DmcTypePrimitiveSVREFSET dmcTypePrimitiveSVREFSET = this;
        synchronized (dmcTypePrimitiveSVREFSET) {
            PrimitiveSVDMO rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrimitiveSVDMO del(Object v) {
        DmcTypePrimitiveSVREFSET dmcTypePrimitiveSVREFSET = this;
        synchronized (dmcTypePrimitiveSVREFSET) {
            PrimitiveSVDMO rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<PrimitiveSVDMO> getMV() {
        DmcTypePrimitiveSVREFSET dmcTypePrimitiveSVREFSET = this;
        synchronized (dmcTypePrimitiveSVREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<PrimitiveSVDMO>(this.value).iterator();
            }
            return new TreeSet<PrimitiveSVDMO>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PrimitiveSVDMO> getMVCopy() {
        DmcTypePrimitiveSVREFSET dmcTypePrimitiveSVREFSET = this;
        synchronized (dmcTypePrimitiveSVREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<PrimitiveSVDMO>();
                }
                return new HashSet<PrimitiveSVDMO>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<PrimitiveSVDMO>(this.value);
            }
            return new TreeSet<PrimitiveSVDMO>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypePrimitiveSVREFSET dmcTypePrimitiveSVREFSET = this;
        synchronized (dmcTypePrimitiveSVREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypePrimitiveSVREFSET dmcTypePrimitiveSVREFSET = this;
        synchronized (dmcTypePrimitiveSVREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                PrimitiveSVDMO val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

