/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.shared.generated.dmo.PrimitiveTMDMO;
import org.dmd.dmt.shared.generated.types.DmcTypePrimitiveTMREF;

public class DmcTypePrimitiveTMREFSET
extends DmcTypePrimitiveTMREF
implements Serializable {
    private static final Iterator<PrimitiveTMDMO> emptyList = new HashSet().iterator();
    protected Set<PrimitiveTMDMO> value;

    public DmcTypePrimitiveTMREFSET() {
        this.value = null;
    }

    public DmcTypePrimitiveTMREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<PrimitiveTMDMO>() : new TreeSet<PrimitiveTMDMO>();
    }

    public DmcTypePrimitiveTMREFSET getNew() {
        return new DmcTypePrimitiveTMREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<PrimitiveTMDMO> cloneIt() {
        DmcTypePrimitiveTMREFSET dmcTypePrimitiveTMREFSET = this;
        synchronized (dmcTypePrimitiveTMREFSET) {
            DmcTypePrimitiveTMREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (PrimitiveTMDMO val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrimitiveTMDMO add(Object v) throws DmcValueException {
        DmcTypePrimitiveTMREFSET dmcTypePrimitiveTMREFSET = this;
        synchronized (dmcTypePrimitiveTMREFSET) {
            PrimitiveTMDMO rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrimitiveTMDMO del(Object v) {
        DmcTypePrimitiveTMREFSET dmcTypePrimitiveTMREFSET = this;
        synchronized (dmcTypePrimitiveTMREFSET) {
            PrimitiveTMDMO rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<PrimitiveTMDMO> getMV() {
        DmcTypePrimitiveTMREFSET dmcTypePrimitiveTMREFSET = this;
        synchronized (dmcTypePrimitiveTMREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<PrimitiveTMDMO>(this.value).iterator();
            }
            return new TreeSet<PrimitiveTMDMO>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PrimitiveTMDMO> getMVCopy() {
        DmcTypePrimitiveTMREFSET dmcTypePrimitiveTMREFSET = this;
        synchronized (dmcTypePrimitiveTMREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<PrimitiveTMDMO>();
                }
                return new HashSet<PrimitiveTMDMO>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<PrimitiveTMDMO>(this.value);
            }
            return new TreeSet<PrimitiveTMDMO>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypePrimitiveTMREFSET dmcTypePrimitiveTMREFSET = this;
        synchronized (dmcTypePrimitiveTMREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypePrimitiveTMREFSET dmcTypePrimitiveTMREFSET = this;
        synchronized (dmcTypePrimitiveTMREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                PrimitiveTMDMO val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

