/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.shared.generated.dmo.PrimitiveTSDMO;
import org.dmd.dmt.shared.generated.types.DmcTypePrimitiveTSREF;

public class DmcTypePrimitiveTSREFSET
extends DmcTypePrimitiveTSREF
implements Serializable {
    private static final Iterator<PrimitiveTSDMO> emptyList = new HashSet().iterator();
    protected Set<PrimitiveTSDMO> value;

    public DmcTypePrimitiveTSREFSET() {
        this.value = null;
    }

    public DmcTypePrimitiveTSREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<PrimitiveTSDMO>() : new TreeSet<PrimitiveTSDMO>();
    }

    public DmcTypePrimitiveTSREFSET getNew() {
        return new DmcTypePrimitiveTSREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<PrimitiveTSDMO> cloneIt() {
        DmcTypePrimitiveTSREFSET dmcTypePrimitiveTSREFSET = this;
        synchronized (dmcTypePrimitiveTSREFSET) {
            DmcTypePrimitiveTSREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (PrimitiveTSDMO val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrimitiveTSDMO add(Object v) throws DmcValueException {
        DmcTypePrimitiveTSREFSET dmcTypePrimitiveTSREFSET = this;
        synchronized (dmcTypePrimitiveTSREFSET) {
            PrimitiveTSDMO rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrimitiveTSDMO del(Object v) {
        DmcTypePrimitiveTSREFSET dmcTypePrimitiveTSREFSET = this;
        synchronized (dmcTypePrimitiveTSREFSET) {
            PrimitiveTSDMO rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<PrimitiveTSDMO> getMV() {
        DmcTypePrimitiveTSREFSET dmcTypePrimitiveTSREFSET = this;
        synchronized (dmcTypePrimitiveTSREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<PrimitiveTSDMO>(this.value).iterator();
            }
            return new TreeSet<PrimitiveTSDMO>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PrimitiveTSDMO> getMVCopy() {
        DmcTypePrimitiveTSREFSET dmcTypePrimitiveTSREFSET = this;
        synchronized (dmcTypePrimitiveTSREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<PrimitiveTSDMO>();
                }
                return new HashSet<PrimitiveTSDMO>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<PrimitiveTSDMO>(this.value);
            }
            return new TreeSet<PrimitiveTSDMO>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypePrimitiveTSREFSET dmcTypePrimitiveTSREFSET = this;
        synchronized (dmcTypePrimitiveTSREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypePrimitiveTSREFSET dmcTypePrimitiveTSREFSET = this;
        synchronized (dmcTypePrimitiveTSREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                PrimitiveTSDMO val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

