/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.shared.generated.types.DmcTypeSomeRelation;
import org.dmd.dmt.shared.generated.types.SomeRelation;

public class DmcTypeSomeRelationSET
extends DmcTypeSomeRelation
implements Serializable {
    private static final Iterator<SomeRelation> emptyList = new HashSet().iterator();
    protected Set<SomeRelation> value;

    public DmcTypeSomeRelationSET() {
        this.value = null;
    }

    public DmcTypeSomeRelationSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<SomeRelation>() : new TreeSet<SomeRelation>();
    }

    public DmcTypeSomeRelationSET getNew() {
        return new DmcTypeSomeRelationSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<SomeRelation> cloneIt() {
        DmcTypeSomeRelationSET dmcTypeSomeRelationSET = this;
        synchronized (dmcTypeSomeRelationSET) {
            DmcTypeSomeRelationSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (SomeRelation val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SomeRelation add(Object v) throws DmcValueException {
        DmcTypeSomeRelationSET dmcTypeSomeRelationSET = this;
        synchronized (dmcTypeSomeRelationSET) {
            SomeRelation rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SomeRelation del(Object v) {
        DmcTypeSomeRelationSET dmcTypeSomeRelationSET = this;
        synchronized (dmcTypeSomeRelationSET) {
            SomeRelation rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<SomeRelation> getMV() {
        DmcTypeSomeRelationSET dmcTypeSomeRelationSET = this;
        synchronized (dmcTypeSomeRelationSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<SomeRelation>(this.value).iterator();
            }
            return new TreeSet<SomeRelation>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<SomeRelation> getMVCopy() {
        DmcTypeSomeRelationSET dmcTypeSomeRelationSET = this;
        synchronized (dmcTypeSomeRelationSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<SomeRelation>();
                }
                return new HashSet<SomeRelation>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<SomeRelation>(this.value);
            }
            return new TreeSet<SomeRelation>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeSomeRelationSET dmcTypeSomeRelationSET = this;
        synchronized (dmcTypeSomeRelationSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeSomeRelationSET dmcTypeSomeRelationSET = this;
        synchronized (dmcTypeSomeRelationSET) {
            if (this.value == null) {
                return false;
            }
            try {
                SomeRelation val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

