/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.shared.generated.dmo.TestBasicObjectFixedDMO;
import org.dmd.dmt.shared.generated.types.DmcTypeTestBasicObjectFixedREF;

public class DmcTypeTestBasicObjectFixedREFSET
extends DmcTypeTestBasicObjectFixedREF
implements Serializable {
    private static final Iterator<TestBasicObjectFixedDMO> emptyList = new HashSet().iterator();
    protected Set<TestBasicObjectFixedDMO> value;

    public DmcTypeTestBasicObjectFixedREFSET() {
        this.value = null;
    }

    public DmcTypeTestBasicObjectFixedREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<TestBasicObjectFixedDMO>() : new TreeSet<TestBasicObjectFixedDMO>();
    }

    public DmcTypeTestBasicObjectFixedREFSET getNew() {
        return new DmcTypeTestBasicObjectFixedREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<TestBasicObjectFixedDMO> cloneIt() {
        DmcTypeTestBasicObjectFixedREFSET dmcTypeTestBasicObjectFixedREFSET = this;
        synchronized (dmcTypeTestBasicObjectFixedREFSET) {
            DmcTypeTestBasicObjectFixedREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (TestBasicObjectFixedDMO val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestBasicObjectFixedDMO add(Object v) throws DmcValueException {
        DmcTypeTestBasicObjectFixedREFSET dmcTypeTestBasicObjectFixedREFSET = this;
        synchronized (dmcTypeTestBasicObjectFixedREFSET) {
            TestBasicObjectFixedDMO rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestBasicObjectFixedDMO del(Object v) {
        DmcTypeTestBasicObjectFixedREFSET dmcTypeTestBasicObjectFixedREFSET = this;
        synchronized (dmcTypeTestBasicObjectFixedREFSET) {
            TestBasicObjectFixedDMO rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<TestBasicObjectFixedDMO> getMV() {
        DmcTypeTestBasicObjectFixedREFSET dmcTypeTestBasicObjectFixedREFSET = this;
        synchronized (dmcTypeTestBasicObjectFixedREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<TestBasicObjectFixedDMO>(this.value).iterator();
            }
            return new TreeSet<TestBasicObjectFixedDMO>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TestBasicObjectFixedDMO> getMVCopy() {
        DmcTypeTestBasicObjectFixedREFSET dmcTypeTestBasicObjectFixedREFSET = this;
        synchronized (dmcTypeTestBasicObjectFixedREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<TestBasicObjectFixedDMO>();
                }
                return new HashSet<TestBasicObjectFixedDMO>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<TestBasicObjectFixedDMO>(this.value);
            }
            return new TreeSet<TestBasicObjectFixedDMO>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeTestBasicObjectFixedREFSET dmcTypeTestBasicObjectFixedREFSET = this;
        synchronized (dmcTypeTestBasicObjectFixedREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeTestBasicObjectFixedREFSET dmcTypeTestBasicObjectFixedREFSET = this;
        synchronized (dmcTypeTestBasicObjectFixedREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                TestBasicObjectFixedDMO val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

