/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.shared.generated.types.DmcTypeUUIDNamedObjectREF;
import org.dmd.dmt.shared.generated.types.UUIDNamedObjectREF;

public class DmcTypeUUIDNamedObjectREFSET
extends DmcTypeUUIDNamedObjectREF
implements Serializable {
    private static final Iterator<UUIDNamedObjectREF> emptyList = new HashSet().iterator();
    protected Set<UUIDNamedObjectREF> value;

    public DmcTypeUUIDNamedObjectREFSET() {
        this.value = null;
    }

    public DmcTypeUUIDNamedObjectREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<UUIDNamedObjectREF>() : new TreeSet<UUIDNamedObjectREF>();
    }

    public DmcTypeUUIDNamedObjectREFSET getNew() {
        return new DmcTypeUUIDNamedObjectREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<UUIDNamedObjectREF> cloneIt() {
        DmcTypeUUIDNamedObjectREFSET dmcTypeUUIDNamedObjectREFSET = this;
        synchronized (dmcTypeUUIDNamedObjectREFSET) {
            DmcTypeUUIDNamedObjectREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (UUIDNamedObjectREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUIDNamedObjectREF add(Object v) throws DmcValueException {
        DmcTypeUUIDNamedObjectREFSET dmcTypeUUIDNamedObjectREFSET = this;
        synchronized (dmcTypeUUIDNamedObjectREFSET) {
            UUIDNamedObjectREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUIDNamedObjectREF del(Object v) {
        DmcTypeUUIDNamedObjectREFSET dmcTypeUUIDNamedObjectREFSET = this;
        synchronized (dmcTypeUUIDNamedObjectREFSET) {
            UUIDNamedObjectREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<UUIDNamedObjectREF> getMV() {
        DmcTypeUUIDNamedObjectREFSET dmcTypeUUIDNamedObjectREFSET = this;
        synchronized (dmcTypeUUIDNamedObjectREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<UUIDNamedObjectREF>(this.value).iterator();
            }
            return new TreeSet<UUIDNamedObjectREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<UUIDNamedObjectREF> getMVCopy() {
        DmcTypeUUIDNamedObjectREFSET dmcTypeUUIDNamedObjectREFSET = this;
        synchronized (dmcTypeUUIDNamedObjectREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<UUIDNamedObjectREF>();
                }
                return new HashSet<UUIDNamedObjectREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<UUIDNamedObjectREF>(this.value);
            }
            return new TreeSet<UUIDNamedObjectREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeUUIDNamedObjectREFSET dmcTypeUUIDNamedObjectREFSET = this;
        synchronized (dmcTypeUUIDNamedObjectREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeUUIDNamedObjectREFSET dmcTypeUUIDNamedObjectREFSET = this;
        synchronized (dmcTypeUUIDNamedObjectREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                UUIDNamedObjectREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

