/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.shared.generated.dmo.UnnamedObjHSDMO;
import org.dmd.dmt.shared.generated.types.DmcTypeUnnamedObjHSREF;

public class DmcTypeUnnamedObjHSREFSET
extends DmcTypeUnnamedObjHSREF
implements Serializable {
    private static final Iterator<UnnamedObjHSDMO> emptyList = new HashSet().iterator();
    protected Set<UnnamedObjHSDMO> value;

    public DmcTypeUnnamedObjHSREFSET() {
        this.value = null;
    }

    public DmcTypeUnnamedObjHSREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<UnnamedObjHSDMO>() : new TreeSet<UnnamedObjHSDMO>();
    }

    public DmcTypeUnnamedObjHSREFSET getNew() {
        return new DmcTypeUnnamedObjHSREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<UnnamedObjHSDMO> cloneIt() {
        DmcTypeUnnamedObjHSREFSET dmcTypeUnnamedObjHSREFSET = this;
        synchronized (dmcTypeUnnamedObjHSREFSET) {
            DmcTypeUnnamedObjHSREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (UnnamedObjHSDMO val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UnnamedObjHSDMO add(Object v) throws DmcValueException {
        DmcTypeUnnamedObjHSREFSET dmcTypeUnnamedObjHSREFSET = this;
        synchronized (dmcTypeUnnamedObjHSREFSET) {
            UnnamedObjHSDMO rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UnnamedObjHSDMO del(Object v) {
        DmcTypeUnnamedObjHSREFSET dmcTypeUnnamedObjHSREFSET = this;
        synchronized (dmcTypeUnnamedObjHSREFSET) {
            UnnamedObjHSDMO rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<UnnamedObjHSDMO> getMV() {
        DmcTypeUnnamedObjHSREFSET dmcTypeUnnamedObjHSREFSET = this;
        synchronized (dmcTypeUnnamedObjHSREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<UnnamedObjHSDMO>(this.value).iterator();
            }
            return new TreeSet<UnnamedObjHSDMO>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<UnnamedObjHSDMO> getMVCopy() {
        DmcTypeUnnamedObjHSREFSET dmcTypeUnnamedObjHSREFSET = this;
        synchronized (dmcTypeUnnamedObjHSREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<UnnamedObjHSDMO>();
                }
                return new HashSet<UnnamedObjHSDMO>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<UnnamedObjHSDMO>(this.value);
            }
            return new TreeSet<UnnamedObjHSDMO>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeUnnamedObjHSREFSET dmcTypeUnnamedObjHSREFSET = this;
        synchronized (dmcTypeUnnamedObjHSREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeUnnamedObjHSREFSET dmcTypeUnnamedObjHSREFSET = this;
        synchronized (dmcTypeUnnamedObjHSREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                UnnamedObjHSDMO val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

