/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.shared.generated.dmo.UnnamedObjMVDMO;
import org.dmd.dmt.shared.generated.types.DmcTypeUnnamedObjMVREF;

public class DmcTypeUnnamedObjMVREFSET
extends DmcTypeUnnamedObjMVREF
implements Serializable {
    private static final Iterator<UnnamedObjMVDMO> emptyList = new HashSet().iterator();
    protected Set<UnnamedObjMVDMO> value;

    public DmcTypeUnnamedObjMVREFSET() {
        this.value = null;
    }

    public DmcTypeUnnamedObjMVREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<UnnamedObjMVDMO>() : new TreeSet<UnnamedObjMVDMO>();
    }

    public DmcTypeUnnamedObjMVREFSET getNew() {
        return new DmcTypeUnnamedObjMVREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<UnnamedObjMVDMO> cloneIt() {
        DmcTypeUnnamedObjMVREFSET dmcTypeUnnamedObjMVREFSET = this;
        synchronized (dmcTypeUnnamedObjMVREFSET) {
            DmcTypeUnnamedObjMVREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (UnnamedObjMVDMO val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UnnamedObjMVDMO add(Object v) throws DmcValueException {
        DmcTypeUnnamedObjMVREFSET dmcTypeUnnamedObjMVREFSET = this;
        synchronized (dmcTypeUnnamedObjMVREFSET) {
            UnnamedObjMVDMO rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UnnamedObjMVDMO del(Object v) {
        DmcTypeUnnamedObjMVREFSET dmcTypeUnnamedObjMVREFSET = this;
        synchronized (dmcTypeUnnamedObjMVREFSET) {
            UnnamedObjMVDMO rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<UnnamedObjMVDMO> getMV() {
        DmcTypeUnnamedObjMVREFSET dmcTypeUnnamedObjMVREFSET = this;
        synchronized (dmcTypeUnnamedObjMVREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<UnnamedObjMVDMO>(this.value).iterator();
            }
            return new TreeSet<UnnamedObjMVDMO>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<UnnamedObjMVDMO> getMVCopy() {
        DmcTypeUnnamedObjMVREFSET dmcTypeUnnamedObjMVREFSET = this;
        synchronized (dmcTypeUnnamedObjMVREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<UnnamedObjMVDMO>();
                }
                return new HashSet<UnnamedObjMVDMO>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<UnnamedObjMVDMO>(this.value);
            }
            return new TreeSet<UnnamedObjMVDMO>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeUnnamedObjMVREFSET dmcTypeUnnamedObjMVREFSET = this;
        synchronized (dmcTypeUnnamedObjMVREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeUnnamedObjMVREFSET dmcTypeUnnamedObjMVREFSET = this;
        synchronized (dmcTypeUnnamedObjMVREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                UnnamedObjMVDMO val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

