/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.shared.generated.dmo.UnnamedObjTSDMO;
import org.dmd.dmt.shared.generated.types.DmcTypeUnnamedObjTSREF;

public class DmcTypeUnnamedObjTSREFSET
extends DmcTypeUnnamedObjTSREF
implements Serializable {
    private static final Iterator<UnnamedObjTSDMO> emptyList = new HashSet().iterator();
    protected Set<UnnamedObjTSDMO> value;

    public DmcTypeUnnamedObjTSREFSET() {
        this.value = null;
    }

    public DmcTypeUnnamedObjTSREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<UnnamedObjTSDMO>() : new TreeSet<UnnamedObjTSDMO>();
    }

    public DmcTypeUnnamedObjTSREFSET getNew() {
        return new DmcTypeUnnamedObjTSREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<UnnamedObjTSDMO> cloneIt() {
        DmcTypeUnnamedObjTSREFSET dmcTypeUnnamedObjTSREFSET = this;
        synchronized (dmcTypeUnnamedObjTSREFSET) {
            DmcTypeUnnamedObjTSREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (UnnamedObjTSDMO val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UnnamedObjTSDMO add(Object v) throws DmcValueException {
        DmcTypeUnnamedObjTSREFSET dmcTypeUnnamedObjTSREFSET = this;
        synchronized (dmcTypeUnnamedObjTSREFSET) {
            UnnamedObjTSDMO rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UnnamedObjTSDMO del(Object v) {
        DmcTypeUnnamedObjTSREFSET dmcTypeUnnamedObjTSREFSET = this;
        synchronized (dmcTypeUnnamedObjTSREFSET) {
            UnnamedObjTSDMO rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<UnnamedObjTSDMO> getMV() {
        DmcTypeUnnamedObjTSREFSET dmcTypeUnnamedObjTSREFSET = this;
        synchronized (dmcTypeUnnamedObjTSREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<UnnamedObjTSDMO>(this.value).iterator();
            }
            return new TreeSet<UnnamedObjTSDMO>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<UnnamedObjTSDMO> getMVCopy() {
        DmcTypeUnnamedObjTSREFSET dmcTypeUnnamedObjTSREFSET = this;
        synchronized (dmcTypeUnnamedObjTSREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<UnnamedObjTSDMO>();
                }
                return new HashSet<UnnamedObjTSDMO>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<UnnamedObjTSDMO>(this.value);
            }
            return new TreeSet<UnnamedObjTSDMO>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeUnnamedObjTSREFSET dmcTypeUnnamedObjTSREFSET = this;
        synchronized (dmcTypeUnnamedObjTSREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeUnnamedObjTSREFSET dmcTypeUnnamedObjTSREFSET = this;
        synchronized (dmcTypeUnnamedObjTSREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                UnnamedObjTSDMO val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

