/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.shared.generated.types;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.util.ComplexTypeSplitter;
import org.dmd.dmc.util.JSONUtil;
import org.dmd.dmc.util.ParsedNameValuePair;
import org.dmd.dms.generated.enums.DataTypeEnum;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.generated.types.DmcTypeIntegerSTATIC;

public class DmtMultiValuedRequiredPartPrimitive
implements Serializable {
    static final int requiredParts = 1;
    ArrayList<Integer> valueV;
    static final DmcAttributeInfo valueAI = new DmcAttributeInfo("value", 0, "Integer", ValueTypeEnum.SINGLE, DataTypeEnum.UNKNOWN, 0, false);

    public DmtMultiValuedRequiredPartPrimitive() {
    }

    public DmtMultiValuedRequiredPartPrimitive(DmtMultiValuedRequiredPartPrimitive original) {
        this.valueV = (ArrayList)original.valueV.clone();
    }

    public DmtMultiValuedRequiredPartPrimitive(ArrayList<Integer> value_) throws DmcValueException {
        if (value_ != null) {
            this.valueV = new ArrayList();
            for (Integer v : value_) {
                this.valueV.add(DmcTypeIntegerSTATIC.instance.typeCheck(v));
            }
        }
    }

    public DmtMultiValuedRequiredPartPrimitive(String initialInput) throws DmcValueException {
        this.initialize(initialInput);
    }

    void initialize(String initialInput) throws DmcValueException {
        ArrayList<ParsedNameValuePair> nvp = ComplexTypeSplitter.parse(initialInput);
        if (nvp.size() < 1) {
            throw new DmcValueException("Missing required values for complex type: DmtMultiValuedRequiredPartPrimitive\nValue: " + initialInput);
        }
        if (nvp.size() >= 1) {
            for (int i = 0; i < nvp.size(); ++i) {
                if (this.valueV == null) {
                    this.valueV = new ArrayList();
                }
                this.valueV.add(DmcTypeIntegerSTATIC.instance.typeCheck(nvp.get(i).getValue()));
            }
        }
    }

    public void serializeIt(DmcOutputStreamIF dos) throws Exception {
        dos.writeUTF(this.toString());
    }

    public void deserializeIt(DmcInputStreamIF dis) throws Exception {
        this.initialize(dis.readUTF());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (Integer v : this.valueV) {
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(v.toString());
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DmtMultiValuedRequiredPartPrimitive) {
            return this.toString().equals(((DmtMultiValuedRequiredPartPrimitive)obj).toString());
        }
        return false;
    }

    public void toJSON(StringBuffer sb, int padding, String indent) {
        sb.append(indent + "{\n");
        sb.append(indent + "  \"value\": [\n");
        Iterator<Integer> it = this.valueV.iterator();
        while (it.hasNext()) {
            Integer v = it.next();
            sb.append(indent + "  \"" + JSONUtil.escape(v.toString()) + "\"");
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        sb.append("\n" + indent + "]");
        sb.append("\n" + indent + "}");
    }

    public Iterator<Integer> getValue() {
        if (this.valueV == null) {
            return null;
        }
        return this.valueV.iterator();
    }

    public boolean hasValue() {
        return this.valueV != null;
    }

    public int getValueSize() {
        if (this.valueV == null) {
            return 0;
        }
        return this.valueV.size();
    }

    public Integer getValue(int index) {
        if (this.valueV == null) {
            return null;
        }
        return this.valueV.get(index);
    }
}

