/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.shared.generated.types;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcContainerIF;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcNameClashResolverIF;
import org.dmd.dmc.DmcNameResolverIF;
import org.dmd.dmc.DmcNameResolverWithClashSupportIF;
import org.dmd.dmc.DmcNamedObjectIF;
import org.dmd.dmc.DmcNamedObjectREF;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcOmni;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.DmcValueExceptionSet;
import org.dmd.dmc.types.Modifier;
import org.dmd.dmc.util.ComplexTypeSplitter;
import org.dmd.dmc.util.JSONUtil;
import org.dmd.dmc.util.ParsedNameValuePair;
import org.dmd.dms.generated.enums.DataTypeEnum;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.generated.types.DmcTypeTypeDefinitionREFSTATIC;
import org.dmd.dms.generated.types.TypeDefinitionREF;

public class DmtMultiValuedRequiredPartWithReferences
implements Serializable {
    static final int requiredParts = 1;
    ArrayList<TypeDefinitionREF> typeV;
    static final DmcAttributeInfo typeAI = new DmcAttributeInfo("type", 0, "TypeDefinition", ValueTypeEnum.SINGLE, DataTypeEnum.UNKNOWN, 0, false);

    public DmtMultiValuedRequiredPartWithReferences() {
    }

    public DmtMultiValuedRequiredPartWithReferences(DmtMultiValuedRequiredPartWithReferences original) {
        this.typeV = (ArrayList)original.typeV.clone();
    }

    public DmtMultiValuedRequiredPartWithReferences(ArrayList<TypeDefinitionREF> type_) throws DmcValueException {
        if (type_ != null) {
            this.typeV = new ArrayList();
            for (TypeDefinitionREF v : type_) {
                this.typeV.add(DmcTypeTypeDefinitionREFSTATIC.instance.typeCheck(v));
            }
        }
    }

    public DmtMultiValuedRequiredPartWithReferences(String initialInput) throws DmcValueException {
        this.initialize(initialInput);
    }

    void initialize(String initialInput) throws DmcValueException {
        ArrayList<ParsedNameValuePair> nvp = ComplexTypeSplitter.parse(initialInput);
        if (nvp.size() < 1) {
            throw new DmcValueException("Missing required values for complex type: DmtMultiValuedRequiredPartWithReferences\nValue: " + initialInput);
        }
        if (nvp.size() >= 1) {
            for (int i = 0; i < nvp.size(); ++i) {
                if (this.typeV == null) {
                    this.typeV = new ArrayList();
                }
                this.typeV.add(DmcTypeTypeDefinitionREFSTATIC.instance.typeCheck(nvp.get(i).getValue()));
            }
        }
    }

    public void serializeIt(DmcOutputStreamIF dos) throws Exception {
        dos.writeUTF(this.toString());
    }

    public void deserializeIt(DmcInputStreamIF dis) throws Exception {
        this.initialize(dis.readUTF());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (TypeDefinitionREF v : this.typeV) {
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(v.toString());
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DmtMultiValuedRequiredPartWithReferences) {
            return this.toString().equals(((DmtMultiValuedRequiredPartWithReferences)obj).toString());
        }
        return false;
    }

    public void toJSON(StringBuffer sb, int padding, String indent) {
        sb.append(indent + "{\n");
        sb.append(indent + "  \"type\": [\n");
        Iterator<TypeDefinitionREF> it = this.typeV.iterator();
        while (it.hasNext()) {
            TypeDefinitionREF v = it.next();
            sb.append(indent + "  \"" + JSONUtil.escape(v.toString()) + "\"");
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        sb.append("\n" + indent + "]");
        sb.append("\n" + indent + "}");
    }

    public Iterator<TypeDefinitionREF> getType() {
        if (this.typeV == null) {
            return null;
        }
        return this.typeV.iterator();
    }

    public boolean hasType() {
        return this.typeV != null;
    }

    public int getTypeSize() {
        if (this.typeV == null) {
            return 0;
        }
        return this.typeV.size();
    }

    public TypeDefinitionREF getType(int index) {
        if (this.typeV == null) {
            return null;
        }
        return this.typeV.get(index);
    }

    public void resolve(DmcNameResolverIF resolver, String attrName) throws DmcValueException {
        DmcNamedObjectIF obj = null;
        if (this.typeV != null) {
            for (TypeDefinitionREF v : this.typeV) {
                if (v.isResolved()) continue;
                obj = resolver.findNamedObject(v.getObjectName());
                if (DmtMultiValuedRequiredPartWithReferences.typeAI.weakReference) {
                    return;
                }
                if (obj == null) {
                    throw new DmcValueException("Could not resolve reference to: " + v.getObjectName() + " (part: type - of type: TypeDefinition) via attribute: " + attrName);
                }
                if (obj instanceof DmcContainerIF) {
                    ((DmcNamedObjectREF)v).setObject((DmcNamedObjectIF)((Object)((DmcContainerIF)((Object)obj)).getDmcObject()));
                    continue;
                }
                ((DmcNamedObjectREF)v).setObject(obj);
            }
        }
    }

    public void resolve(DmcNameResolverWithClashSupportIF resolver, DmcObject object, DmcNameClashResolverIF ncr, DmcAttributeInfo ai) throws DmcValueException, DmcValueExceptionSet {
        DmcNamedObjectIF obj = null;
        if (this.typeV != null) {
            for (TypeDefinitionREF v : this.typeV) {
                if (v.isResolved()) continue;
                obj = resolver.findNamedObjectMayClash(object, v.getObjectName(), ncr, typeAI);
                if (DmtMultiValuedRequiredPartWithReferences.typeAI.weakReference) {
                    return;
                }
                if (obj == null) {
                    throw new DmcValueException("Could not resolve reference to: " + v.getObjectName() + " via attribute: " + ai.name);
                }
                if (obj instanceof DmcContainerIF) {
                    ((DmcNamedObjectREF)v).setObject((DmcNamedObjectIF)((Object)((DmcContainerIF)((Object)obj)).getDmcObject()));
                } else {
                    ((DmcNamedObjectREF)v).setObject(obj);
                }
                if (!DmcOmni.instance().backRefTracking()) continue;
                Modifier backrefMod = new Modifier("type", object, v, ai.id);
                if (obj instanceof DmcContainerIF) {
                    ((DmcContainerIF)((Object)obj)).getDmcObject().addBackref(backrefMod);
                } else {
                    ((DmcObject)((Object)obj)).addBackref(backrefMod);
                }
                v.setBackrefModifier(backrefMod);
            }
        }
    }

    public void removeBackRefsFromValue() {
        if (this.typeV != null) {
            for (TypeDefinitionREF v : this.typeV) {
                v.removeBackref();
            }
        }
    }
}

