/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.shared.types;

import java.io.Serializable;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcMappedAttributeIF;
import org.dmd.dmc.DmcOutputStreamIF;

public class KeyedType
implements DmcMappedAttributeIF,
Serializable {
    String key;
    String value;

    public KeyedType() {
        this.key = null;
        this.value = null;
    }

    public KeyedType(KeyedType kt) {
        this.key = new String(kt.key);
        this.value = new String(kt.value);
    }

    public KeyedType(String s) {
        String tmp = s.trim();
        int spacepos = tmp.indexOf(32);
        if (spacepos == -1) {
            this.key = tmp;
            this.value = null;
        } else {
            this.key = tmp.substring(0, spacepos);
            this.value = tmp.substring(spacepos + 1);
        }
    }

    public String getValue() {
        return this.value;
    }

    public void serializeIt(DmcOutputStreamIF dos) throws Exception {
        dos.writeUTF(this.key);
        dos.writeUTF(this.value);
    }

    public void deserializeIt(DmcInputStreamIF dis) throws Exception {
        this.key = dis.readUTF();
        this.value = dis.readUTF();
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    @Override
    public String getKeyAsString() {
        return this.key;
    }

    @Override
    public boolean valuesAreEqual(DmcMappedAttributeIF obj) {
        if (obj instanceof KeyedType) {
            KeyedType other = (KeyedType)obj;
            if (this.key.equals(other.key) && this.value.equals(other.key)) {
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof KeyedType) {
            return this.valuesAreEqual((KeyedType)obj);
        }
        return false;
    }
}

