/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmu.server.generated.dsd;

import java.io.IOException;
import java.util.Iterator;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcOmni;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.DmcValueExceptionSet;
import org.dmd.dmc.rules.DmcRuleExceptionSet;
import org.dmd.dmu.server.extended.DmuDefinition;
import org.dmd.dmu.server.extended.DmuModule;
import org.dmd.dmu.server.generated.dsd.DmuModuleDefinitionManager;
import org.dmd.dmu.server.generated.dsd.DmuModuleGenUtility;
import org.dmd.util.exceptions.ResultException;
import org.dmd.util.parsing.ConfigLocation;

public class DmuModuleConfigLoader
extends DmuModuleGenUtility {
    private DmuModuleDefinitionManager definitionManager;

    public DmuModuleConfigLoader() {
        DmcOmni.instance().backRefTracking(true);
    }

    public void loadAllModules(String srcdir) throws ResultException, DmcValueException, IOException, DmcRuleExceptionSet, DmcNameClashException, DmcValueExceptionSet {
        String[] args = new String[]{"-srcdir", srcdir};
        super.run(args);
    }

    public void loadModule(String srcdir, String module) throws ResultException, DmcValueException, IOException, DmcRuleExceptionSet, DmcNameClashException, DmcValueExceptionSet {
        String[] args = new String[]{"-srcdir", srcdir, "-targets", module};
        super.run(args);
    }

    public void addSrcDir(String dir) {
        this.searchPaths.add(dir);
    }

    public DmuModuleDefinitionManager definitionManager() {
        return this.definitionManager;
    }

    @Override
    public void parsingComplete(DmuModule module, ConfigLocation location, DmuModuleDefinitionManager definitions) throws ResultException {
        this.definitionManager = definitions;
    }

    @Override
    public void objectResolutionComplete(DmuModule module, ConfigLocation location, DmuModuleDefinitionManager definitions) throws ResultException {
    }

    @Override
    public void generate(DmuModule module, ConfigLocation location, DmuModuleDefinitionManager definitions) throws ResultException, IOException {
        this.initializeDefinitions();
    }

    @Override
    public void generate(DmuModuleDefinitionManager definitions) throws ResultException, IOException {
        this.initializeDefinitions();
    }

    @Override
    public void displayHelp() {
    }

    private void initializeDefinitions() throws ResultException {
        Iterator<DmuDefinition> DmuDefinitionIT = this.definitionManager.getAllDmuDefinition();
        while (DmuDefinitionIT.hasNext()) {
            DmuDefinition def = DmuDefinitionIT.next();
            def.initialize(this.definitionManager);
        }
    }
}

