/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmu.server.generated.dsd;

import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcClassInfo;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcNameClashObjectSet;
import org.dmd.dmc.DmcNameClashResolverIF;
import org.dmd.dmc.DmcNameResolverWithClashSupportIF;
import org.dmd.dmc.DmcNamedObjectIF;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcObjectName;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.DmcValueExceptionSet;
import org.dmd.dmc.definitions.DmcDefinitionSet;
import org.dmd.dmc.types.DotName;
import org.dmd.dms.DSDefinition;
import org.dmd.dmu.server.extended.DmuDefinition;
import org.dmd.dmu.server.extended.DmuModule;
import org.dmd.dmu.server.extended.json.PayloadExample;
import org.dmd.dmu.server.extended.json.PayloadSortInfo;
import org.dmd.dmu.server.generated.dsd.DmuModuleDefinitionsIF;
import org.dmd.dmu.server.generated.dsd.DmuModuleGlobalInterface;
import org.dmd.dmu.shared.generated.dmo.DmuDMSAG;
import org.dmd.dmw.DmwNamedObjectWrapper;
import org.dmd.util.exceptions.ResultException;

public class DmuModuleDefinitionManager
implements DmcNameClashResolverIF,
DmcNameResolverWithClashSupportIF,
DmuModuleGlobalInterface,
DmuModuleDefinitionsIF {
    private DmcDefinitionSet<DSDefinition> allDefinitions = new DmcDefinitionSet("allDefinitions");
    private DmcDefinitionSet<DmuDefinition> DmuDefinitionDefs;
    private DmcDefinitionSet<DmuModule> DmuModuleDefs;
    private DmcDefinitionSet<PayloadExample> PayloadExampleDefs;
    private DmcDefinitionSet<PayloadSortInfo> PayloadSortInfoDefs;
    private TreeMap<DmcClassInfo, DmcDefinitionSet<?>> indicesByClass = new TreeMap();

    public DmuModuleDefinitionManager() {
        this.DmuDefinitionDefs = new DmcDefinitionSet("DmuDefinition", this.allDefinitions);
        this.indicesByClass.put(DmuDMSAG.__DmuDefinition, this.DmuDefinitionDefs);
        this.PayloadSortInfoDefs = new DmcDefinitionSet("PayloadSortInfo", this.allDefinitions, this.DmuDefinitionDefs);
        this.indicesByClass.put(DmuDMSAG.__PayloadSortInfo, this.PayloadSortInfoDefs);
        this.PayloadExampleDefs = new DmcDefinitionSet("PayloadExample", this.allDefinitions, this.DmuDefinitionDefs);
        this.indicesByClass.put(DmuDMSAG.__PayloadExample, this.PayloadExampleDefs);
        this.DmuModuleDefs = new DmcDefinitionSet("DmuModule", this.allDefinitions, this.DmuDefinitionDefs);
        this.indicesByClass.put(DmuDMSAG.__DmuModule, this.DmuModuleDefs);
    }

    public void resolveReferences() throws DmcValueExceptionSet {
        for (DSDefinition def : this.allDefinitions.values()) {
            def.resolveReferences(this, this);
        }
    }

    public Collection<DmwNamedObjectWrapper> getIndex(DmcClassInfo ci) {
        DmcDefinitionSet<?> dds = this.indicesByClass.get(ci);
        if (dds == null) {
            throw new IllegalStateException("No index available for class: " + ci.name);
        }
        return dds.getIndex();
    }

    @Override
    public DmcNamedObjectIF findNamedObject(DmcObjectName name) {
        DSDefinition def = null;
        try {
            def = this.allDefinitions.getDefinition(name.toString());
        }
        catch (DmcNameClashException e) {
            e.printStackTrace();
        }
        catch (DmcValueException e) {
            e.printStackTrace();
        }
        return def;
    }

    public DSDefinition findDefinition(DotName name) {
        return this.allDefinitions.getDefinition(name);
    }

    public void deleteDefinition(DotName name) throws ResultException {
        DSDefinition def = this.allDefinitions.getDefinition(name);
        if (def == null) {
            throw new ResultException("Could not find object to delete: " + name.getNameString());
        }
        DmcDefinitionSet<?> dds = this.indicesByClass.get(def.getConstructionClassInfo());
        dds.delete(name);
        def.youAreDeleted();
        DmuDefinition base = (DmuDefinition)def;
        DmuModule module = base.getDefinedInDmuModule();
        if (def instanceof PayloadExample) {
            module.deletePayloadExample((PayloadExample)def);
        } else if (def instanceof PayloadSortInfo) {
            module.deletePayloadSortInfo((PayloadSortInfo)def);
        } else if (def instanceof DmuModule) {
            // empty if block
        }
    }

    @Override
    public DmcNamedObjectIF findNamedObject(DmcObjectName name, int attributeID) {
        throw new IllegalStateException("This method is not supported on generated definition managers");
    }

    @Override
    public DmcObject findNamedDMO(DmcObjectName name) {
        DSDefinition def = null;
        try {
            def = this.allDefinitions.getDefinition(name.toString());
        }
        catch (DmcNameClashException e) {
            e.printStackTrace();
        }
        catch (DmcValueException e) {
            e.printStackTrace();
        }
        if (def == null) {
            return null;
        }
        return def.getDMO();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DmcNamedObjectIF findNamedObjectMayClash(DmcObject object, DmcObjectName name, DmcNameClashResolverIF resolver, DmcAttributeInfo ai) throws DmcValueException {
        void var5_9;
        Object var5_5 = null;
        DotName dn = new DotName(name.getNameString() + "." + ai.type);
        if (name.getNameString().indexOf(".") == -1) {
            try {
                DSDefinition dSDefinition = this.allDefinitions.getDefinitionByNameAndType(dn);
                return var5_9;
            }
            catch (DmcNameClashException e) {
                DmcNamedObjectIF dmcNamedObjectIF = resolver.resolveClash(object, ai, e.getClashSet());
                if (dmcNamedObjectIF != null) return var5_9;
                DmcValueException ex = new DmcValueException("The reference to : " + name.getNameString() + " is ambiguous. You must specify the module name as a prefix to the name. Here are your options:");
                Iterator<DmcNamedObjectIF> it = e.getMatches();
                while (it.hasNext()) {
                    DmuDefinition def = (DmuDefinition)it.next();
                    ex.addMoreInfo(def.getDefinedInDmuModule().getName().getNameString() + "." + name.getNameString());
                }
                throw ex;
            }
        } else {
            DSDefinition dSDefinition = this.allDefinitions.getDefinition(dn);
        }
        return var5_9;
    }

    @Override
    public DmcNamedObjectIF resolveClash(DmcObject obj, DmcAttributeInfo ai, DmcNameClashObjectSet<?> ncos) throws DmcValueException {
        DSDefinition rc = null;
        DSDefinition resolving = (DSDefinition)obj.getContainer();
        Iterator<DmcNamedObjectIF> it = ncos.getMatches();
        while (it.hasNext()) {
            DSDefinition def = (DSDefinition)it.next();
            if (!resolving.getNameOfModuleWhereThisCameFrom().equals(def.getNameOfModuleWhereThisCameFrom())) continue;
            rc = def;
            break;
        }
        return rc;
    }

    void addDmuDefinition(DmuDefinition def) {
        this.DmuDefinitionDefs.add(def);
    }

    void deleteDmuDefinition(DmuDefinition def) {
        try {
            this.DmuDefinitionDefs.delete(def);
        }
        catch (ResultException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int getDmuDefinitionCount() {
        return this.DmuDefinitionDefs.size();
    }

    @Override
    public DmuDefinition getDmuDefinition(DotName name) {
        return this.DmuDefinitionDefs.getDefinition(name);
    }

    @Override
    public Iterator<DmuDefinition> getAllDmuDefinition() {
        return this.DmuDefinitionDefs.values().iterator();
    }

    @Override
    public void addDmuModule(DmuModule def) {
        this.DmuModuleDefs.add(def);
        this.addDmuDefinition(def);
    }

    @Override
    public void deleteDmuModule(DmuModule def) {
        try {
            this.DmuModuleDefs.delete(def);
        }
        catch (ResultException e) {
            throw new IllegalStateException(e);
        }
        this.deleteDmuDefinition(def);
    }

    @Override
    public int getDmuModuleCount() {
        return this.DmuModuleDefs.size();
    }

    @Override
    public DmuModule getDmuModule(DotName name) {
        return this.DmuModuleDefs.getDefinition(name);
    }

    @Override
    public Iterator<DmuModule> getAllDmuModule() {
        return this.DmuModuleDefs.values().iterator();
    }

    @Override
    public DmuModule getDmuModuleDefinition(String name) throws DmcNameClashException, DmcValueException {
        return this.DmuModuleDefs.getDefinition(name);
    }

    @Override
    public Iterator<DmuModule> getDmuModuleDefinitionsByName(String name) throws DmcValueException {
        return this.DmuModuleDefs.getDefinitionsByName(name);
    }

    @Override
    public int getDmuModuleDefinitionCountByName(String name) throws DmcValueException {
        return this.DmuModuleDefs.getDefinitionCountByName(name);
    }

    @Override
    public void addPayloadExample(PayloadExample def) {
        this.PayloadExampleDefs.add(def);
        this.addDmuDefinition(def);
    }

    @Override
    public void deletePayloadExample(PayloadExample def) {
        try {
            this.PayloadExampleDefs.delete(def);
        }
        catch (ResultException e) {
            throw new IllegalStateException(e);
        }
        this.deleteDmuDefinition(def);
    }

    @Override
    public int getPayloadExampleCount() {
        return this.PayloadExampleDefs.size();
    }

    @Override
    public PayloadExample getPayloadExample(DotName name) {
        return this.PayloadExampleDefs.getDefinition(name);
    }

    @Override
    public Iterator<PayloadExample> getAllPayloadExample() {
        return this.PayloadExampleDefs.values().iterator();
    }

    @Override
    public PayloadExample getPayloadExampleDefinition(String name) throws DmcNameClashException, DmcValueException {
        return this.PayloadExampleDefs.getDefinition(name);
    }

    @Override
    public Iterator<PayloadExample> getPayloadExampleDefinitionsByName(String name) throws DmcValueException {
        return this.PayloadExampleDefs.getDefinitionsByName(name);
    }

    @Override
    public int getPayloadExampleDefinitionCountByName(String name) throws DmcValueException {
        return this.PayloadExampleDefs.getDefinitionCountByName(name);
    }

    @Override
    public void addPayloadSortInfo(PayloadSortInfo def) {
        this.PayloadSortInfoDefs.add(def);
        this.addDmuDefinition(def);
    }

    @Override
    public void deletePayloadSortInfo(PayloadSortInfo def) {
        try {
            this.PayloadSortInfoDefs.delete(def);
        }
        catch (ResultException e) {
            throw new IllegalStateException(e);
        }
        this.deleteDmuDefinition(def);
    }

    @Override
    public int getPayloadSortInfoCount() {
        return this.PayloadSortInfoDefs.size();
    }

    @Override
    public PayloadSortInfo getPayloadSortInfo(DotName name) {
        return this.PayloadSortInfoDefs.getDefinition(name);
    }

    @Override
    public Iterator<PayloadSortInfo> getAllPayloadSortInfo() {
        return this.PayloadSortInfoDefs.values().iterator();
    }

    @Override
    public PayloadSortInfo getPayloadSortInfoDefinition(String name) throws DmcNameClashException, DmcValueException {
        return this.PayloadSortInfoDefs.getDefinition(name);
    }

    @Override
    public Iterator<PayloadSortInfo> getPayloadSortInfoDefinitionsByName(String name) throws DmcValueException {
        return this.PayloadSortInfoDefs.getDefinitionsByName(name);
    }

    @Override
    public int getPayloadSortInfoDefinitionCountByName(String name) throws DmcValueException {
        return this.PayloadSortInfoDefs.getDefinitionCountByName(name);
    }

    public void addDefinition(DSDefinition definition) {
        if (definition instanceof PayloadExample) {
            this.addPayloadExample((PayloadExample)definition);
        } else if (definition instanceof PayloadSortInfo) {
            this.addPayloadSortInfo((PayloadSortInfo)definition);
        } else if (definition instanceof DmuModule) {
            this.addDmuModule((DmuModule)definition);
        }
    }

    public void addDefinition(DSDefinition definition, DmuModule module) {
        if (definition instanceof PayloadExample) {
            this.addPayloadExample((PayloadExample)definition);
            module.addPayloadExample((PayloadExample)definition);
        } else if (definition instanceof PayloadSortInfo) {
            this.addPayloadSortInfo((PayloadSortInfo)definition);
            module.addPayloadSortInfo((PayloadSortInfo)definition);
        } else if (definition instanceof DmuModule) {
            this.addDmuModule((DmuModule)definition);
        }
    }

    public String summary() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.DmuDefinitionDefs.summary());
        sb.append(this.PayloadSortInfoDefs.summary());
        sb.append(this.PayloadExampleDefs.summary());
        sb.append(this.DmuModuleDefs.summary());
        return sb.toString();
    }
}

