/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmu.server.generated.dsd;

import java.util.Iterator;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.definitions.DsdParserInterface;
import org.dmd.dmc.rules.DmcRuleExceptionSet;
import org.dmd.dmc.rules.SourceInfo;
import org.dmd.dmc.util.DmcUncheckedObject;
import org.dmd.dms.AttributeDefinition;
import org.dmd.dms.MetaSchema;
import org.dmd.dms.SchemaDefinition;
import org.dmd.dms.SchemaManager;
import org.dmd.dms.generated.dmw.AttributeDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.StringIterableDMW;
import org.dmd.dms.generated.types.SchemaAndReason;
import org.dmd.dmu.server.extended.DmuDefinition;
import org.dmd.dmu.server.extended.DmuModule;
import org.dmd.dmu.server.extended.json.PayloadExample;
import org.dmd.dmu.server.extended.json.PayloadSortInfo;
import org.dmd.dmu.server.generated.DmuSchemaAG;
import org.dmd.dmu.server.generated.dsd.DmuModuleGlobalInterface;
import org.dmd.dmu.shared.generated.dmo.DmuDMSAG;
import org.dmd.dmv.shared.DmvRuleManager;
import org.dmd.dmw.DmwObjectFactory;
import org.dmd.dmw.DmwWrapper;
import org.dmd.util.exceptions.ResultException;
import org.dmd.util.parsing.ConfigLocation;
import org.dmd.util.parsing.DmcUncheckedOIFHandlerIF;
import org.dmd.util.parsing.DmcUncheckedOIFParser;

public class DmuModuleParser
implements DsdParserInterface,
DmcUncheckedOIFHandlerIF {
    static final String fileExtension = "dmu";
    SchemaManager schema;
    DmcUncheckedOIFParser parser = new DmcUncheckedOIFParser(this);
    DmwObjectFactory factory;
    DmuModuleGlobalInterface definitions;
    DmvRuleManager rules;
    ConfigLocation location;
    DmuModule module;

    public DmuModuleParser(DmuModuleGlobalInterface d, DmvRuleManager r) throws ResultException, DmcValueException, DmcNameClashException {
        this.schema = new SchemaManager();
        DmuSchemaAG sd = new DmuSchemaAG();
        this.schema.manageSchema(sd.getInstance());
        if (sd.getAttributeDefListSize() > 0) {
            this.preserveNewLines(sd.getAttributeDefList());
        }
        this.preserveNewLines(MetaSchema._metaSchema.getAttributeDefList());
        this.factory = new DmwObjectFactory(this.schema);
        this.definitions = d;
        this.rules = r;
        this.rules.loadRules(DmuDMSAG.instance());
    }

    public SchemaManager schema() {
        return this.schema;
    }

    void preserveNewLines(AttributeDefinitionIterableDMW attrs) {
        while (attrs.hasNext()) {
            AttributeDefinition ad = (AttributeDefinition)attrs.getNext();
            if (!ad.getPreserveNewlines().booleanValue()) continue;
            this.parser.addPreserveNewlinesAttribute(ad.getName().getNameString());
        }
    }

    @Override
    public String getFileExtension() {
        return fileExtension;
    }

    public DmuModule parseConfig(ConfigLocation l) throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException {
        this.location = l;
        this.module = null;
        if (this.location.isFromJAR()) {
            System.out.println("Reading: " + this.location.getFileName() + " - from " + this.location.getJarFilename());
            this.parser.parseFile(this.location.getFileName(), true);
        } else {
            System.out.println("Reading: " + this.location.getFileName());
            this.parser.parseFile(this.location.getFileName());
        }
        if (this.module.getDefFilesHasValue()) {
            StringIterableDMW it = this.module.getDefFilesIterable();
            while (it.hasNext()) {
                String fn = this.location.getDirectory() + "/" + (String)it.next();
                if (this.location.isFromJAR()) {
                    this.parser.parseFile(fn, true);
                    continue;
                }
                this.parser.parseFile(fn);
            }
        }
        return this.module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleObject(DmcUncheckedObject uco, String infile, int lineNumber) throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException {
        DmuDefinition definition = null;
        DmwWrapper wrapper = null;
        try {
            wrapper = this.factory.createWrapper(uco);
            definition = (DmuDefinition)wrapper;
        }
        catch (ClassNotFoundException e) {
            ResultException ex = new ResultException("Unknown object class: " + uco.classes.get(0));
            ex.result.lastResult().fileName(infile);
            ex.result.lastResult().lineNumber(lineNumber);
            throw ex;
        }
        catch (ResultException ex) {
            ex.setLocationInfo(infile, lineNumber);
            throw ex;
        }
        catch (DmcValueException e) {
            ResultException ex = new ResultException();
            ex.addError(e.getMessage());
            if (e.getAttributeName() != null) {
                ex.result.lastResult().moreMessages("Attribute: " + e.getAttributeName());
            }
            ex.setLocationInfo(infile, lineNumber);
            throw ex;
        }
        catch (ClassCastException e) {
            ResultException ex = new ResultException();
            ex.addError("All classes in your DSL must ultimately be derived from: DmuDefinition");
            ex.addError("The following object is not valid in a .dmu file:\n\n" + wrapper.toOIF());
            ex.setLocationInfo(infile, lineNumber);
            throw ex;
        }
        definition.setLineNumber(lineNumber);
        definition.setFile(infile);
        try {
            this.rules.executeInitializers(definition.getDmcObject());
        }
        catch (DmcRuleExceptionSet ex) {
            ex.source(new SourceInfo(infile, lineNumber));
            throw ex;
        }
        if (this.module == null) {
            if (!(definition instanceof DmuModule)) {
                ResultException ex = new ResultException("Expecting a DmuModule module definition");
                ex.setLocationInfo(infile, lineNumber);
                throw ex;
            }
            this.module = (DmuModule)definition;
            int lastSep = infile.lastIndexOf("/");
            int period = infile.lastIndexOf(46);
            String fn = infile.substring(lastSep + 1, period);
            if (this.module.getName() == null) {
                ResultException ex = new ResultException("Missing name attribute for module definition");
                ex.setLocationInfo(infile, lineNumber);
                throw ex;
            }
            if (!this.module.getName().getNameString().equals(fn)) {
                ResultException ex = new ResultException("Module name: " + this.module.getName().getNameString() + " - must match file name: " + fn);
                ex.setLocationInfo(infile, lineNumber);
                throw ex;
            }
            definition.setDotName(this.module.getName() + "." + this.module.getName() + "." + definition.getConstructionClassName());
            this.module.setDefinedInDmuModule(this.module);
            this.definitions.addDmuModule(this.module);
            if (this.module.getLoadSchemaClassHasValue()) {
                this.loadSchemas(this.module);
            }
        } else {
            if (definition instanceof DmuModule) {
                ResultException ex = new ResultException("Multiple DmuModule definitions while parsing config: " + this.location.getFileName());
                ex.setLocationInfo(infile, lineNumber);
                throw ex;
            }
            definition.setDefinedInDmuModule(this.module);
            definition.setDmoFromModule(this.module.getName().getNameString());
            definition.setDotName(this.module.getName() + "." + definition.getName() + "." + definition.getConstructionClassName());
            try {
                this.rules.executeObjectValidation(definition.getDmcObject());
            }
            catch (DmcRuleExceptionSet ex) {
                ex.source(new SourceInfo(infile, lineNumber));
                throw ex;
            }
            if (definition instanceof PayloadExample) {
                this.definitions.addPayloadExample((PayloadExample)definition);
                this.module.addPayloadExample((PayloadExample)definition);
            } else if (definition instanceof PayloadSortInfo) {
                this.definitions.addPayloadSortInfo((PayloadSortInfo)definition);
                this.module.addPayloadSortInfo((PayloadSortInfo)definition);
            }
        }
        try {
            this.rules.executeAttributeValidation(definition.getDmcObject());
            this.rules.executeObjectValidation(definition.getDmcObject());
            return;
        }
        catch (DmcRuleExceptionSet ex) {
            ex.source(new SourceInfo(infile, lineNumber));
            throw ex;
        }
    }

    void loadSchemas(DmuModule module) throws ResultException {
        Class<?> schemaClass = null;
        SchemaDefinition sd = null;
        Iterator<SchemaAndReason> it = module.getDMO().getLoadSchemaClass();
        while (it.hasNext()) {
            ResultException ex;
            SchemaAndReason sar = it.next();
            String cn = sar.getSchema();
            try {
                schemaClass = Class.forName(cn);
            }
            catch (ClassNotFoundException e) {
                ex = new ResultException(e);
                ex.addError("Couldn't load schema class: " + cn);
                ex.setLocationInfo(module.getFile(), module.getLineNumber());
                throw ex;
            }
            try {
                Object obj = schemaClass.newInstance();
                if (!(obj instanceof SchemaDefinition)) {
                    ex = new ResultException("The specified class is not a SchemaDefinition: " + cn);
                    ex.setLocationInfo(module.getFile(), module.getLineNumber());
                    throw ex;
                }
                sd = (SchemaDefinition)obj;
            }
            catch (Exception e) {
                ex = new ResultException(e);
                ex.addError("Couldn't instantiate schema class: " + cn);
                ex.setLocationInfo(module.getFile(), module.getLineNumber());
                throw ex;
            }
            try {
                if (this.schema.isSchema(sd.getInstance().getName().getNameString()) != null) continue;
                this.schema.manageSchema(sd);
                if (sd.getAttributeDefListSize() <= 0) continue;
                AttributeDefinitionIterableDMW attrs = sd.getAttributeDefList();
                while (attrs.hasNext()) {
                    AttributeDefinition ad = (AttributeDefinition)attrs.getNext();
                    if (!ad.getPreserveNewlines().booleanValue()) continue;
                    this.parser.addPreserveNewlinesAttribute(ad.getName().getNameString());
                }
            }
            catch (DmcValueException e) {
                e.printStackTrace();
            }
            catch (DmcNameClashException e) {
                e.printStackTrace();
            }
        }
    }
}

