/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmu.server.generated.dsd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.DmcValueExceptionSet;
import org.dmd.dmc.rules.DmcRuleExceptionSet;
import org.dmd.dmc.types.DefinitionName;
import org.dmd.dms.DSDefinition;
import org.dmd.dmu.server.extended.DmuModule;
import org.dmd.dmu.server.generated.dsd.DmuModuleDefinitionManager;
import org.dmd.dmu.server.generated.dsd.DmuModuleGeneratorInterface;
import org.dmd.dmu.server.generated.dsd.DmuModuleParser;
import org.dmd.dmu.shared.generated.types.DmuModuleREF;
import org.dmd.dmv.shared.DmvRuleManager;
import org.dmd.util.exceptions.ResultException;
import org.dmd.util.parsing.ConfigFinder;
import org.dmd.util.parsing.ConfigLocation;
import org.dmd.util.parsing.ConfigVersion;

public class DmuModuleParsingCoordinator {
    DmvRuleManager rules = new DmvRuleManager();
    DmuModuleDefinitionManager definitions = new DmuModuleDefinitionManager();
    DmuModuleGeneratorInterface generator;
    TreeMap<String, ModuleInfoBase> loadedConfigs = new TreeMap();
    DmuModuleParser parserForDmuModule;
    ConfigFinder finderForDmuModule = new ConfigFinder(".dmu");
    TreeMap<DefinitionName, DmuModuleInfo> loadedDmuModuleConfigs = new TreeMap();

    public DmuModuleParsingCoordinator(DmuModuleGeneratorInterface g, ArrayList<String> sourceDirs, ArrayList<String> jars) throws ResultException, DmcValueException, DmcNameClashException, DmcRuleExceptionSet, IOException {
        this.generator = g;
        this.parserForDmuModule = new DmuModuleParser(this.definitions, this.rules);
        this.finderForDmuModule.setSourceAndJarInfo(sourceDirs, jars);
        this.finderForDmuModule.findConfigs();
    }

    public DmvRuleManager getRuleManager() {
        return this.rules;
    }

    public DmuModuleParser parserForDmuModule() {
        return this.parserForDmuModule;
    }

    public void generateForConfig(String configName) throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException, DmcValueExceptionSet, IOException {
        ConfigVersion version = this.finderForDmuModule.getConfig(configName);
        if (version == null) {
            ResultException ex = new ResultException("Could not find the specified configuration file: " + configName);
            throw ex;
        }
        ConfigLocation location = version.getLatestVersion();
        DmuModule loaded = this.loadDmuModuleModule(location);
        if (location.isFromJAR()) {
            ResultException ex = new ResultException("We can't run generation for a config loaded from a JAR: " + configName);
            ex.moreMessages(location.toString());
            throw ex;
        }
        this.generator.parsingComplete(loaded, location, this.definitions);
        this.definitions.resolveReferences();
        this.generator.generate(loaded, location, this.definitions);
    }

    public void generateForAllConfigs() throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException, DmcValueExceptionSet, IOException {
        DmuModule loaded = null;
        DmuModuleInfo loadedInfo = null;
        Iterator<ConfigLocation> it = this.finderForDmuModule.getLocations();
        while (it.hasNext()) {
            ConfigLocation location = it.next();
            loadedInfo = (DmuModuleInfo)this.loadedConfigs.get(location.getFileName());
            loaded = loadedInfo == null ? this.loadDmuModuleModule(location) : loadedInfo.module;
            this.generator.parsingComplete(loaded, location, this.definitions);
            this.definitions.resolveReferences();
            this.generator.objectResolutionComplete(loaded, location, this.definitions);
        }
        this.generator.generate(this.definitions);
    }

    DmuModule loadDmuModuleModule(ConfigLocation location) throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException {
        DmuModuleInfo info = this.loadedDmuModuleConfigs.get(new DefinitionName(location.getConfigName()));
        if (info != null) {
            return info.module;
        }
        DmuModule loaded = this.parserForDmuModule.parseConfig(location);
        DmuModuleInfo loadedInfo = new DmuModuleInfo(loaded, location);
        this.loadedDmuModuleConfigs.put(loaded.getName(), loadedInfo);
        this.loadedConfigs.put(location.getFileName(), loadedInfo);
        this.loadModuleDependencies(loadedInfo);
        return loaded;
    }

    public ConfigLocation getLocation(DmuModule module) {
        DmuModuleInfo info = this.loadedDmuModuleConfigs.get(module.getName());
        if (info == null) {
            throw new IllegalStateException("Couldn't find ConfigLocation for module: \n\n" + module.toOIF());
        }
        return info.location;
    }

    void loadModuleDependencies(ModuleInfoBase mi) throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException {
        if (mi.dependenciesLoaded) {
            return;
        }
        if (mi instanceof DmuModuleInfo) {
            DmuModuleInfo info = (DmuModuleInfo)mi;
            if (info.module.getDependsOnDmuModuleHasValue()) {
                Iterator<DmuModuleREF> it = info.module.getDMO().getDependsOnDmuModule();
                while (it.hasNext()) {
                    DmuModuleREF ref = it.next();
                    ConfigVersion version = this.finderForDmuModule.getConfig(ref.toString());
                    if (version == null) {
                        this.missingConfigError(info.module, ref.toString() + ".dmu");
                    }
                    this.loadDmuModuleModule(version.getLatestVersion());
                }
            }
            info.dependenciesLoaded = true;
        }
    }

    void missingConfigError(String missing) throws ResultException {
        ResultException ex = new ResultException("Could not find config: " + missing);
        throw ex;
    }

    void missingConfigError(DSDefinition module, String missing) throws ResultException {
        ResultException ex = new ResultException("Could not find config: " + missing);
        ex.setLocationInfo(module.getFile(), module.getLineNumber());
        throw ex;
    }

    class DmuModuleInfo
    extends ModuleInfoBase {
        DmuModule module;

        DmuModuleInfo(DmuModule m, ConfigLocation l) {
            this.module = m;
            this.location = l;
        }
    }

    class ModuleInfoBase {
        ConfigLocation location;
        boolean dependenciesLoaded;

        ModuleInfoBase() {
        }
    }
}

