/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmu.shared.generated.dsd;

import java.util.Iterator;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcNameClashObjectSet;
import org.dmd.dmc.DmcNameClashResolverIF;
import org.dmd.dmc.DmcNameResolverWithClashSupportIF;
import org.dmd.dmc.DmcNamedObjectIF;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcObjectName;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.DmcValueExceptionSet;
import org.dmd.dmc.definitions.DMODefinitionSet;
import org.dmd.dmc.types.DotName;
import org.dmd.dms.generated.dmo.DSDefinitionDMO;
import org.dmd.dmu.shared.generated.dmo.DmuDMSAG;
import org.dmd.dmu.shared.generated.dmo.DmuDefinitionDMO;
import org.dmd.dmu.shared.generated.dmo.DmuModuleDMO;
import org.dmd.dmu.shared.generated.dmo.PayloadExampleDMO;
import org.dmd.dmu.shared.generated.dmo.PayloadSortInfoDMO;
import org.dmd.dmu.shared.generated.dsd.DmuModuleGlobalInterface;
import org.dmd.dmv.shared.DmvRuleManager;

public class DmuModuleDefinitionDMOCache
implements DmcNameClashResolverIF,
DmcNameResolverWithClashSupportIF,
DmuModuleGlobalInterface {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private DmvRuleManager ruleManager = new DmvRuleManager();
    private DMODefinitionSet<DSDefinitionDMO> allDefinitions;
    private TreeMap<String, DMODefinitionSet<?>> indicesByClass;
    private DMODefinitionSet<DmuDefinitionDMO> DmuDefinitionDefs;
    private DMODefinitionSet<DmuModuleDMO> DmuModuleDefs;
    private DMODefinitionSet<PayloadExampleDMO> PayloadExampleDefs;
    private DMODefinitionSet<PayloadSortInfoDMO> PayloadSortInfoDefs;

    public DmuModuleDefinitionDMOCache() {
        this.ruleManager.loadRules(DmuDMSAG.instance());
        this.allDefinitions = new DMODefinitionSet("allDefinitions");
        this.indicesByClass = new TreeMap();
        this.DmuDefinitionDefs = new DMODefinitionSet("DmuDefinition", this.allDefinitions);
        this.indicesByClass.put(this.DmuDefinitionDefs.className(), this.DmuDefinitionDefs);
        this.PayloadSortInfoDefs = new DMODefinitionSet("PayloadSortInfo", this.allDefinitions, this.DmuDefinitionDefs);
        this.indicesByClass.put(this.PayloadSortInfoDefs.className(), this.PayloadSortInfoDefs);
        this.PayloadExampleDefs = new DMODefinitionSet("PayloadExample", this.allDefinitions, this.DmuDefinitionDefs);
        this.indicesByClass.put(this.PayloadExampleDefs.className(), this.PayloadExampleDefs);
        this.DmuModuleDefs = new DMODefinitionSet("DmuModule", this.allDefinitions, this.DmuDefinitionDefs);
        this.indicesByClass.put(this.DmuModuleDefs.className(), this.DmuModuleDefs);
    }

    public DmvRuleManager ruleManager() {
        return this.ruleManager;
    }

    public void resolveReferences() throws DmcValueExceptionSet {
        for (DSDefinitionDMO def : this.allDefinitions.values()) {
            def.resolveReferencesExceptClass(this, this);
        }
    }

    @Override
    public DmcNamedObjectIF findNamedObject(DmcObjectName name) {
        DSDefinitionDMO def = null;
        try {
            def = this.allDefinitions.getDefinition(name.toString());
        }
        catch (DmcNameClashException e) {
            this.logger.fine(e.toString());
        }
        catch (DmcValueException e) {
            this.logger.fine(e.toString());
        }
        return def;
    }

    public DSDefinitionDMO findDefinition(DotName name) {
        return this.allDefinitions.getDefinition(name);
    }

    public void deleteDefinition(DotName name) throws Exception {
        DSDefinitionDMO def = this.allDefinitions.getDefinition(name);
        if (def == null) {
            throw new Exception("Could not find object to delete: " + name.getNameString());
        }
        DMODefinitionSet<?> dds = this.indicesByClass.get(def.getConstructionClassName());
        dds.delete(name);
        def.youAreDeleted();
    }

    @Override
    public DmcNamedObjectIF findNamedObject(DmcObjectName name, int attributeID) {
        throw new IllegalStateException("This method is not supported on generated definition managers");
    }

    @Override
    public DmcObject findNamedDMO(DmcObjectName name) {
        DSDefinitionDMO def = null;
        try {
            def = name instanceof DotName ? this.allDefinitions.getDefinition((DotName)name) : this.allDefinitions.getDefinition(name.toString());
        }
        catch (DmcNameClashException e) {
            this.logger.fine(e.toString());
        }
        catch (DmcValueException e) {
            this.logger.fine(e.toString());
        }
        return def;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DmcNamedObjectIF findNamedObjectMayClash(DmcObject object, DmcObjectName name, DmcNameClashResolverIF resolver, DmcAttributeInfo ai) throws DmcValueException {
        void var5_9;
        Object var5_5 = null;
        DotName dn = new DotName(name.getNameString() + "." + ai.type);
        if (name.getNameString().indexOf(".") == -1) {
            try {
                DSDefinitionDMO dSDefinitionDMO = this.allDefinitions.getDefinitionByNameAndType(dn);
                return var5_9;
            }
            catch (DmcNameClashException e) {
                DmcNamedObjectIF dmcNamedObjectIF = resolver.resolveClash(object, ai, e.getClashSet());
                if (dmcNamedObjectIF != null) return var5_9;
                DmcValueException ex = new DmcValueException("The reference to : " + name.getNameString() + " is ambiguous. You must specify the module name as a prefix to the name. Here are your options:");
                Iterator<DmcNamedObjectIF> it = e.getMatches();
                while (it.hasNext()) {
                    DmuDefinitionDMO def = (DmuDefinitionDMO)it.next();
                    ex.addMoreInfo(def.getDefinedInDmuModule().getName().getNameString() + "." + name.getNameString());
                }
                throw ex;
            }
        } else {
            DSDefinitionDMO dSDefinitionDMO = this.allDefinitions.getDefinition(dn);
        }
        return var5_9;
    }

    @Override
    public DmcNamedObjectIF resolveClash(DmcObject obj, DmcAttributeInfo ai, DmcNameClashObjectSet<?> ncos) throws DmcValueException {
        DSDefinitionDMO rc = null;
        DSDefinitionDMO resolving = (DSDefinitionDMO)((Object)obj.getContainer());
        Iterator<DmcNamedObjectIF> it = ncos.getMatches();
        while (it.hasNext()) {
            DSDefinitionDMO def = (DSDefinitionDMO)it.next();
            if (!resolving.getDmoFromModule().equals(def.getDmoFromModule())) continue;
            rc = def;
            break;
        }
        return rc;
    }

    void addDmuDefinition(DmuDefinitionDMO def) {
        this.DmuDefinitionDefs.add(def);
    }

    @Override
    public int getDmuDefinitionCount() {
        return this.DmuDefinitionDefs.size();
    }

    @Override
    public DmuDefinitionDMO getDmuDefinition(DotName name) {
        return this.DmuDefinitionDefs.getDefinition(name);
    }

    @Override
    public Iterator<DmuDefinitionDMO> getAllDmuDefinition() {
        return this.DmuDefinitionDefs.values().iterator();
    }

    @Override
    public void addDmuModule(DmuModuleDMO def) {
        this.DmuModuleDefs.add(def);
        this.addDmuDefinition(def);
    }

    @Override
    public int getDmuModuleCount() {
        return this.DmuModuleDefs.size();
    }

    @Override
    public DmuModuleDMO getDmuModule(DotName name) {
        return this.DmuModuleDefs.getDefinition(name);
    }

    @Override
    public Iterator<DmuModuleDMO> getAllDmuModule() {
        return this.DmuModuleDefs.values().iterator();
    }

    @Override
    public DmuModuleDMO getDmuModuleDefinition(String name) throws DmcNameClashException, DmcValueException {
        return this.DmuModuleDefs.getDefinition(name);
    }

    @Override
    public void addPayloadExample(PayloadExampleDMO def) {
        this.PayloadExampleDefs.add(def);
        this.addDmuDefinition(def);
    }

    @Override
    public int getPayloadExampleCount() {
        return this.PayloadExampleDefs.size();
    }

    @Override
    public PayloadExampleDMO getPayloadExample(DotName name) {
        return this.PayloadExampleDefs.getDefinition(name);
    }

    @Override
    public Iterator<PayloadExampleDMO> getAllPayloadExample() {
        return this.PayloadExampleDefs.values().iterator();
    }

    @Override
    public PayloadExampleDMO getPayloadExampleDefinition(String name) throws DmcNameClashException, DmcValueException {
        return this.PayloadExampleDefs.getDefinition(name);
    }

    @Override
    public void addPayloadSortInfo(PayloadSortInfoDMO def) {
        this.PayloadSortInfoDefs.add(def);
        this.addDmuDefinition(def);
    }

    @Override
    public int getPayloadSortInfoCount() {
        return this.PayloadSortInfoDefs.size();
    }

    @Override
    public PayloadSortInfoDMO getPayloadSortInfo(DotName name) {
        return this.PayloadSortInfoDefs.getDefinition(name);
    }

    @Override
    public Iterator<PayloadSortInfoDMO> getAllPayloadSortInfo() {
        return this.PayloadSortInfoDefs.values().iterator();
    }

    @Override
    public PayloadSortInfoDMO getPayloadSortInfoDefinition(String name) throws DmcNameClashException, DmcValueException {
        return this.PayloadSortInfoDefs.getDefinition(name);
    }

    public void addDefinition(DSDefinitionDMO definition) {
        if (definition instanceof PayloadExampleDMO) {
            this.addPayloadExample((PayloadExampleDMO)definition);
        } else if (definition instanceof PayloadSortInfoDMO) {
            this.addPayloadSortInfo((PayloadSortInfoDMO)definition);
        } else if (definition instanceof DmuModuleDMO) {
            this.addDmuModule((DmuModuleDMO)definition);
        }
    }

    public String summary() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.DmuDefinitionDefs.summary());
        sb.append(this.PayloadSortInfoDefs.summary());
        sb.append(this.PayloadExampleDefs.summary());
        sb.append(this.DmuModuleDefs.summary());
        return sb.toString();
    }
}

