/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmu.shared.generated.types;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DefinitionName;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmu.shared.generated.types.DmcTypeDmuDefinitionREF;
import org.dmd.dmu.shared.generated.types.DmuDefinitionREF;

public class DmcTypeDmuDefinitionREFMAP
extends DmcTypeDmuDefinitionREF
implements Serializable {
    private static final Iterator<DmuDefinitionREF> emptyList = new HashMap().values().iterator();
    protected Map<DefinitionName, DmuDefinitionREF> value;

    public DmcTypeDmuDefinitionREFMAP() {
        this.value = null;
    }

    public DmcTypeDmuDefinitionREFMAP(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<DefinitionName, DmuDefinitionREF>() : new TreeMap<DefinitionName, DmuDefinitionREF>();
    }

    public DefinitionName firstKey() {
        if (this.getAttributeInfo().valueType == ValueTypeEnum.TREEMAPPED) {
            if (this.value == null) {
                return null;
            }
            TreeMap map = (TreeMap)this.value;
            return (DefinitionName)map.firstKey();
        }
        throw new IllegalStateException("Attribute " + this.getAttributeInfo().name + " is HASHMAPPED and doesn't support firstKey()");
    }

    public DmcTypeDmuDefinitionREFMAP getNew() {
        return new DmcTypeDmuDefinitionREFMAP(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<DmuDefinitionREF> cloneIt() {
        DmcTypeDmuDefinitionREFMAP dmcTypeDmuDefinitionREFMAP = this;
        synchronized (dmcTypeDmuDefinitionREFMAP) {
            DmcTypeDmuDefinitionREFMAP rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (DmuDefinitionREF val : this.value.values()) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmuDefinitionREF add(Object v) throws DmcValueException {
        DmcTypeDmuDefinitionREFMAP dmcTypeDmuDefinitionREFMAP = this;
        synchronized (dmcTypeDmuDefinitionREFMAP) {
            DefinitionName key;
            DmuDefinitionREF oldval;
            DmuDefinitionREF newval = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if ((oldval = this.value.put(key = (DefinitionName)newval.getKey(), newval)) != null && oldval.valuesAreEqual(newval)) {
                newval = null;
            }
            return newval;
        }
    }

    @Override
    public DmuDefinitionREF del(Object key) {
        DmcTypeDmuDefinitionREFMAP dmcTypeDmuDefinitionREFMAP = this;
        synchronized (dmcTypeDmuDefinitionREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof DefinitionName) {
                return this.value.remove(key);
            }
            throw new IllegalStateException("Incompatible key type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<DmuDefinitionREF> getMV() {
        DmcTypeDmuDefinitionREFMAP dmcTypeDmuDefinitionREFMAP = this;
        synchronized (dmcTypeDmuDefinitionREFMAP) {
            if (this.value == null) {
                return emptyList;
            }
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<DefinitionName, DmuDefinitionREF>(this.value) : new TreeMap<DefinitionName, DmuDefinitionREF>(this.value);
            return clone.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<DefinitionName, DmuDefinitionREF> getMVCopy() {
        DmcTypeDmuDefinitionREFMAP dmcTypeDmuDefinitionREFMAP = this;
        synchronized (dmcTypeDmuDefinitionREFMAP) {
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? (this.value == null ? new HashMap() : new HashMap<DefinitionName, DmuDefinitionREF>(this.value)) : (this.value == null ? new TreeMap() : new TreeMap<DefinitionName, DmuDefinitionREF>(this.value));
            return clone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeDmuDefinitionREFMAP dmcTypeDmuDefinitionREFMAP = this;
        synchronized (dmcTypeDmuDefinitionREFMAP) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    @Override
    public DmuDefinitionREF getByKey(Object key) {
        DmcTypeDmuDefinitionREFMAP dmcTypeDmuDefinitionREFMAP = this;
        synchronized (dmcTypeDmuDefinitionREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof DefinitionName) {
                return this.value.get((DefinitionName)key);
            }
            throw new IllegalStateException("Incompatible type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeDmuDefinitionREFMAP dmcTypeDmuDefinitionREFMAP = this;
        synchronized (dmcTypeDmuDefinitionREFMAP) {
            if (this.value == null) {
                return false;
            }
            try {
                DmuDefinitionREF val = this.typeCheck(v);
                return this.value.containsValue(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        DmcTypeDmuDefinitionREFMAP dmcTypeDmuDefinitionREFMAP = this;
        synchronized (dmcTypeDmuDefinitionREFMAP) {
            if (this.value == null) {
                return false;
            }
            if (key instanceof DefinitionName) {
                return this.value.containsKey(key);
            }
            return false;
        }
    }
}

