/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmu.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmu.shared.generated.types.DmcTypeDmuDefinitionREF;
import org.dmd.dmu.shared.generated.types.DmuDefinitionREF;

public class DmcTypeDmuDefinitionREFSET
extends DmcTypeDmuDefinitionREF
implements Serializable {
    private static final Iterator<DmuDefinitionREF> emptyList = new HashSet().iterator();
    protected Set<DmuDefinitionREF> value;

    public DmcTypeDmuDefinitionREFSET() {
        this.value = null;
    }

    public DmcTypeDmuDefinitionREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<DmuDefinitionREF>() : new TreeSet<DmuDefinitionREF>();
    }

    public DmcTypeDmuDefinitionREFSET getNew() {
        return new DmcTypeDmuDefinitionREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<DmuDefinitionREF> cloneIt() {
        DmcTypeDmuDefinitionREFSET dmcTypeDmuDefinitionREFSET = this;
        synchronized (dmcTypeDmuDefinitionREFSET) {
            DmcTypeDmuDefinitionREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (DmuDefinitionREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmuDefinitionREF add(Object v) throws DmcValueException {
        DmcTypeDmuDefinitionREFSET dmcTypeDmuDefinitionREFSET = this;
        synchronized (dmcTypeDmuDefinitionREFSET) {
            DmuDefinitionREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmuDefinitionREF del(Object v) {
        DmcTypeDmuDefinitionREFSET dmcTypeDmuDefinitionREFSET = this;
        synchronized (dmcTypeDmuDefinitionREFSET) {
            DmuDefinitionREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<DmuDefinitionREF> getMV() {
        DmcTypeDmuDefinitionREFSET dmcTypeDmuDefinitionREFSET = this;
        synchronized (dmcTypeDmuDefinitionREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<DmuDefinitionREF>(this.value).iterator();
            }
            return new TreeSet<DmuDefinitionREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DmuDefinitionREF> getMVCopy() {
        DmcTypeDmuDefinitionREFSET dmcTypeDmuDefinitionREFSET = this;
        synchronized (dmcTypeDmuDefinitionREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<DmuDefinitionREF>();
                }
                return new HashSet<DmuDefinitionREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<DmuDefinitionREF>(this.value);
            }
            return new TreeSet<DmuDefinitionREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeDmuDefinitionREFSET dmcTypeDmuDefinitionREFSET = this;
        synchronized (dmcTypeDmuDefinitionREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeDmuDefinitionREFSET dmcTypeDmuDefinitionREFSET = this;
        synchronized (dmcTypeDmuDefinitionREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                DmuDefinitionREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

