/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmu.shared.generated.types;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DefinitionName;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmu.shared.generated.types.DmcTypeDmuModuleREF;
import org.dmd.dmu.shared.generated.types.DmuModuleREF;

public class DmcTypeDmuModuleREFMAP
extends DmcTypeDmuModuleREF
implements Serializable {
    private static final Iterator<DmuModuleREF> emptyList = new HashMap().values().iterator();
    protected Map<DefinitionName, DmuModuleREF> value;

    public DmcTypeDmuModuleREFMAP() {
        this.value = null;
    }

    public DmcTypeDmuModuleREFMAP(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<DefinitionName, DmuModuleREF>() : new TreeMap<DefinitionName, DmuModuleREF>();
    }

    public DefinitionName firstKey() {
        if (this.getAttributeInfo().valueType == ValueTypeEnum.TREEMAPPED) {
            if (this.value == null) {
                return null;
            }
            TreeMap map = (TreeMap)this.value;
            return (DefinitionName)map.firstKey();
        }
        throw new IllegalStateException("Attribute " + this.getAttributeInfo().name + " is HASHMAPPED and doesn't support firstKey()");
    }

    public DmcTypeDmuModuleREFMAP getNew() {
        return new DmcTypeDmuModuleREFMAP(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<DmuModuleREF> cloneIt() {
        DmcTypeDmuModuleREFMAP dmcTypeDmuModuleREFMAP = this;
        synchronized (dmcTypeDmuModuleREFMAP) {
            DmcTypeDmuModuleREFMAP rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (DmuModuleREF val : this.value.values()) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmuModuleREF add(Object v) throws DmcValueException {
        DmcTypeDmuModuleREFMAP dmcTypeDmuModuleREFMAP = this;
        synchronized (dmcTypeDmuModuleREFMAP) {
            DefinitionName key;
            DmuModuleREF oldval;
            DmuModuleREF newval = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if ((oldval = this.value.put(key = (DefinitionName)newval.getKey(), newval)) != null && oldval.valuesAreEqual(newval)) {
                newval = null;
            }
            return newval;
        }
    }

    @Override
    public DmuModuleREF del(Object key) {
        DmcTypeDmuModuleREFMAP dmcTypeDmuModuleREFMAP = this;
        synchronized (dmcTypeDmuModuleREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof DefinitionName) {
                return this.value.remove(key);
            }
            throw new IllegalStateException("Incompatible key type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<DmuModuleREF> getMV() {
        DmcTypeDmuModuleREFMAP dmcTypeDmuModuleREFMAP = this;
        synchronized (dmcTypeDmuModuleREFMAP) {
            if (this.value == null) {
                return emptyList;
            }
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<DefinitionName, DmuModuleREF>(this.value) : new TreeMap<DefinitionName, DmuModuleREF>(this.value);
            return clone.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<DefinitionName, DmuModuleREF> getMVCopy() {
        DmcTypeDmuModuleREFMAP dmcTypeDmuModuleREFMAP = this;
        synchronized (dmcTypeDmuModuleREFMAP) {
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? (this.value == null ? new HashMap() : new HashMap<DefinitionName, DmuModuleREF>(this.value)) : (this.value == null ? new TreeMap() : new TreeMap<DefinitionName, DmuModuleREF>(this.value));
            return clone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeDmuModuleREFMAP dmcTypeDmuModuleREFMAP = this;
        synchronized (dmcTypeDmuModuleREFMAP) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    @Override
    public DmuModuleREF getByKey(Object key) {
        DmcTypeDmuModuleREFMAP dmcTypeDmuModuleREFMAP = this;
        synchronized (dmcTypeDmuModuleREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof DefinitionName) {
                return this.value.get((DefinitionName)key);
            }
            throw new IllegalStateException("Incompatible type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeDmuModuleREFMAP dmcTypeDmuModuleREFMAP = this;
        synchronized (dmcTypeDmuModuleREFMAP) {
            if (this.value == null) {
                return false;
            }
            try {
                DmuModuleREF val = this.typeCheck(v);
                return this.value.containsValue(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        DmcTypeDmuModuleREFMAP dmcTypeDmuModuleREFMAP = this;
        synchronized (dmcTypeDmuModuleREFMAP) {
            if (this.value == null) {
                return false;
            }
            if (key instanceof DefinitionName) {
                return this.value.containsKey(key);
            }
            return false;
        }
    }
}

