/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmu.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmu.shared.generated.types.DmcTypeDmuModuleREF;
import org.dmd.dmu.shared.generated.types.DmuModuleREF;

public class DmcTypeDmuModuleREFSET
extends DmcTypeDmuModuleREF
implements Serializable {
    private static final Iterator<DmuModuleREF> emptyList = new HashSet().iterator();
    protected Set<DmuModuleREF> value;

    public DmcTypeDmuModuleREFSET() {
        this.value = null;
    }

    public DmcTypeDmuModuleREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<DmuModuleREF>() : new TreeSet<DmuModuleREF>();
    }

    public DmcTypeDmuModuleREFSET getNew() {
        return new DmcTypeDmuModuleREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<DmuModuleREF> cloneIt() {
        DmcTypeDmuModuleREFSET dmcTypeDmuModuleREFSET = this;
        synchronized (dmcTypeDmuModuleREFSET) {
            DmcTypeDmuModuleREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (DmuModuleREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmuModuleREF add(Object v) throws DmcValueException {
        DmcTypeDmuModuleREFSET dmcTypeDmuModuleREFSET = this;
        synchronized (dmcTypeDmuModuleREFSET) {
            DmuModuleREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmuModuleREF del(Object v) {
        DmcTypeDmuModuleREFSET dmcTypeDmuModuleREFSET = this;
        synchronized (dmcTypeDmuModuleREFSET) {
            DmuModuleREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<DmuModuleREF> getMV() {
        DmcTypeDmuModuleREFSET dmcTypeDmuModuleREFSET = this;
        synchronized (dmcTypeDmuModuleREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<DmuModuleREF>(this.value).iterator();
            }
            return new TreeSet<DmuModuleREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DmuModuleREF> getMVCopy() {
        DmcTypeDmuModuleREFSET dmcTypeDmuModuleREFSET = this;
        synchronized (dmcTypeDmuModuleREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<DmuModuleREF>();
                }
                return new HashSet<DmuModuleREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<DmuModuleREF>(this.value);
            }
            return new TreeSet<DmuModuleREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeDmuModuleREFSET dmcTypeDmuModuleREFSET = this;
        synchronized (dmcTypeDmuModuleREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeDmuModuleREFSET dmcTypeDmuModuleREFSET = this;
        synchronized (dmcTypeDmuModuleREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                DmuModuleREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

