/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmu.shared.generated.types;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmu.shared.types.DmcTypePathAndKey;
import org.dmd.dmu.shared.types.PathAndKey;

public class DmcTypePathAndKeyMV
extends DmcTypePathAndKey
implements Serializable {
    private static final Iterator<PathAndKey> emptyList = new ArrayList().iterator();
    protected ArrayList<PathAndKey> value;

    public DmcTypePathAndKeyMV() {
    }

    public DmcTypePathAndKeyMV(DmcAttributeInfo ai) {
        super(ai);
    }

    public DmcTypePathAndKeyMV getNew() {
        return new DmcTypePathAndKeyMV(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<PathAndKey> cloneIt() {
        DmcTypePathAndKeyMV dmcTypePathAndKeyMV = this;
        synchronized (dmcTypePathAndKeyMV) {
            DmcTypePathAndKeyMV rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            if (this.getAttributeInfo().indexSize == 0) {
                for (PathAndKey val : this.value) {
                    try {
                        rc.add(val);
                    }
                    catch (DmcValueException e) {
                        throw new IllegalStateException("typeCheck() should never fail here!", e);
                    }
                }
            } else {
                for (int index = 0; index < this.value.size(); ++index) {
                    try {
                        rc.setMVnth(index, this.value.get(index));
                        continue;
                    }
                    catch (DmcValueException e) {
                        throw new IllegalStateException("typeCheck() should never fail here!", e);
                    }
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PathAndKey add(Object v) throws DmcValueException {
        DmcTypePathAndKeyMV dmcTypePathAndKeyMV = this;
        synchronized (dmcTypePathAndKeyMV) {
            PathAndKey rc = this.typeCheck(v);
            if (this.value == null) {
                this.value = new ArrayList();
            }
            this.value.add(rc);
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PathAndKey del(Object v) {
        DmcTypePathAndKeyMV dmcTypePathAndKeyMV = this;
        synchronized (dmcTypePathAndKeyMV) {
            if (this.value == null) {
                return null;
            }
            PathAndKey key = null;
            PathAndKey rc = null;
            try {
                key = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            int indexof = this.value.indexOf(key);
            if (indexof != -1) {
                rc = this.value.get(indexof);
                this.value.remove(rc);
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<PathAndKey> getMV() {
        DmcTypePathAndKeyMV dmcTypePathAndKeyMV = this;
        synchronized (dmcTypePathAndKeyMV) {
            if (this.value == null) {
                return emptyList;
            }
            ArrayList<PathAndKey> clone = new ArrayList<PathAndKey>(this.value);
            return clone.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<PathAndKey> getMVCopy() {
        DmcTypePathAndKeyMV dmcTypePathAndKeyMV = this;
        synchronized (dmcTypePathAndKeyMV) {
            if (this.value == null) {
                return new ArrayList<PathAndKey>();
            }
            return new ArrayList<PathAndKey>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypePathAndKeyMV dmcTypePathAndKeyMV = this;
        synchronized (dmcTypePathAndKeyMV) {
            if (this.getAttributeInfo().indexSize == 0) {
                if (this.value == null) {
                    return 0;
                }
                return this.value.size();
            }
            return this.getAttributeInfo().indexSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PathAndKey getMVnth(int index) {
        DmcTypePathAndKeyMV dmcTypePathAndKeyMV = this;
        synchronized (dmcTypePathAndKeyMV) {
            if (this.value == null) {
                return null;
            }
            return this.value.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PathAndKey setMVnth(int index, Object v) throws DmcValueException {
        DmcTypePathAndKeyMV dmcTypePathAndKeyMV = this;
        synchronized (dmcTypePathAndKeyMV) {
            if (this.getAttributeInfo().indexSize == 0) {
                throw new IllegalStateException("Attribute: " + this.getAttributeInfo().name + " is not indexed. You can't use setMVnth().");
            }
            if (index < 0 || index >= this.getAttributeInfo().indexSize) {
                throw new IllegalStateException("Index " + index + " for attribute: " + this.getAttributeInfo().name + " is out of range: 0 <= index < " + this.getAttributeInfo().indexSize);
            }
            PathAndKey rc = null;
            if (v != null) {
                rc = this.typeCheck(v);
            }
            if (this.value == null) {
                this.value = new ArrayList(this.getAttributeInfo().indexSize);
                for (int i = 0; i < this.getAttributeInfo().indexSize; ++i) {
                    this.value.add(null);
                }
            }
            this.value.set(index, rc);
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasValue() {
        DmcTypePathAndKeyMV dmcTypePathAndKeyMV = this;
        synchronized (dmcTypePathAndKeyMV) {
            boolean rc = false;
            if (this.getAttributeInfo().indexSize == 0) {
                throw new IllegalStateException("Attribute: " + this.getAttributeInfo().name + " is not indexed. You can't use hasValue().");
            }
            if (this.value == null) {
                return rc;
            }
            for (int i = 0; i < this.value.size(); ++i) {
                if (this.value.get(i) == null) continue;
                rc = true;
                break;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypePathAndKeyMV dmcTypePathAndKeyMV = this;
        synchronized (dmcTypePathAndKeyMV) {
            if (this.value == null) {
                return false;
            }
            try {
                PathAndKey val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

