/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmu.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmu.shared.types.DmcTypePathAndKey;
import org.dmd.dmu.shared.types.PathAndKey;

public class DmcTypePathAndKeySET
extends DmcTypePathAndKey
implements Serializable {
    private static final Iterator<PathAndKey> emptyList = new HashSet().iterator();
    protected Set<PathAndKey> value;

    public DmcTypePathAndKeySET() {
        this.value = null;
    }

    public DmcTypePathAndKeySET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<PathAndKey>() : new TreeSet<PathAndKey>();
    }

    public DmcTypePathAndKeySET getNew() {
        return new DmcTypePathAndKeySET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<PathAndKey> cloneIt() {
        DmcTypePathAndKeySET dmcTypePathAndKeySET = this;
        synchronized (dmcTypePathAndKeySET) {
            DmcTypePathAndKeySET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (PathAndKey val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PathAndKey add(Object v) throws DmcValueException {
        DmcTypePathAndKeySET dmcTypePathAndKeySET = this;
        synchronized (dmcTypePathAndKeySET) {
            PathAndKey rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PathAndKey del(Object v) {
        DmcTypePathAndKeySET dmcTypePathAndKeySET = this;
        synchronized (dmcTypePathAndKeySET) {
            PathAndKey rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<PathAndKey> getMV() {
        DmcTypePathAndKeySET dmcTypePathAndKeySET = this;
        synchronized (dmcTypePathAndKeySET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<PathAndKey>(this.value).iterator();
            }
            return new TreeSet<PathAndKey>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PathAndKey> getMVCopy() {
        DmcTypePathAndKeySET dmcTypePathAndKeySET = this;
        synchronized (dmcTypePathAndKeySET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<PathAndKey>();
                }
                return new HashSet<PathAndKey>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<PathAndKey>(this.value);
            }
            return new TreeSet<PathAndKey>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypePathAndKeySET dmcTypePathAndKeySET = this;
        synchronized (dmcTypePathAndKeySET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypePathAndKeySET dmcTypePathAndKeySET = this;
        synchronized (dmcTypePathAndKeySET) {
            if (this.value == null) {
                return false;
            }
            try {
                PathAndKey val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

