/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmu.shared.types;

import java.util.ArrayList;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.CheapSplitter;

public class PathAndKey {
    public static final int ML = 2;
    public static final String START_MARKER = "{{";
    public static final String END_MARKER = "}}";
    protected String pathAndKey;
    protected String path;
    protected String key;

    public PathAndKey() {
        this.pathAndKey = null;
        this.path = null;
        this.key = null;
    }

    public PathAndKey(String pathAndKey) throws DmcValueException {
        this.pathAndKey = pathAndKey;
        this.init();
    }

    public PathAndKey(String path, String key) throws DmcValueException {
        this.pathAndKey = path + " " + key;
        this.path = path;
        this.key = key;
    }

    public String path() {
        return this.path;
    }

    public String key() {
        return this.key;
    }

    private void init() throws DmcValueException {
        int spacePos = this.pathAndKey.indexOf(" ");
        if (spacePos == -1) {
            throw new DmcValueException("A PathAndKey must have a path value seperated by a space from a key value.");
        }
        ArrayList<String> parts = CheapSplitter.split(this.pathAndKey, ' ', false, true);
        if (parts.size() != 2) {
            throw new DmcValueException("A PathAndKey must have a path value seperated by a space from a key value.");
        }
        this.path = parts.get(0);
        this.key = parts.get(1);
    }

    public PathAndKey(PathAndKey ts) {
        this.pathAndKey = new String(ts.pathAndKey);
        this.path = ts.path;
        this.key = ts.key;
    }

    public void serializeIt(DmcOutputStreamIF dos) throws Exception {
        dos.writeUTF(this.pathAndKey);
    }

    public void deserializeIt(DmcInputStreamIF dis) throws Exception {
        this.pathAndKey = dis.readUTF();
        this.init();
    }
}

