/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmu.util.json;

import java.util.Iterator;
import java.util.TreeMap;
import org.dmd.dmu.shared.types.PathAndKey;
import org.dmd.dmu.util.json.JSONUtil;
import org.dmd.util.exceptions.DebugInfo;
import org.json.JSONArray;
import org.json.JSONObject;

public class DeepSort {
    public String sort(JSONObject object, TreeMap<String, PathAndKey> pathInfo) {
        StringBuilder sb = new StringBuilder();
        this.orderObject(object, sb, pathInfo, "");
        return sb.toString();
    }

    private void orderObject(JSONObject object, StringBuilder sb, TreeMap<String, PathAndKey> pathInfo, String path) {
        Object value;
        JType type;
        TreeMap<String, JType> primitives = new TreeMap<String, JType>();
        TreeMap<String, JType> objects = new TreeMap<String, JType>();
        TreeMap<String, JType> arrays = new TreeMap<String, JType>();
        int leftToPrint = 0;
        Iterator keyIT = object.keys();
        while (keyIT.hasNext()) {
            String key = (String)keyIT.next();
            JType type2 = this.categorize(JSONUtil.getValue(object, key));
            switch (type2) {
                case ARRAY: 
                case OBJECT_ARRAY: {
                    arrays.put(key, type2);
                    break;
                }
                case BOOLEAN: 
                case NUMBER: 
                case NULL: 
                case STRING: {
                    primitives.put(key, type2);
                    break;
                }
                case OBJECT: {
                    objects.put(key, type2);
                }
            }
            ++leftToPrint;
        }
        sb.append("{ ");
        for (String key : primitives.keySet()) {
            type = (JType)((Object)primitives.get(key));
            value = JSONUtil.getValue(object, key);
            sb.append("\"" + key + "\": ");
            if (type == JType.STRING) {
                sb.append("\"" + value.toString() + "\"");
            } else if (type == null) {
                sb.append("" + value.toString() + "");
            } else {
                sb.append("" + value.toString() + "");
            }
            if (--leftToPrint <= 0) continue;
            sb.append(", ");
        }
        for (String key : objects.keySet()) {
            Object value2 = JSONUtil.getValue(object, key);
            sb.append("\"" + key + "\": ");
            this.orderObject((JSONObject)value2, sb, pathInfo, path + "/" + key);
            if (--leftToPrint <= 0) continue;
            sb.append(", ");
        }
        for (String key : arrays.keySet()) {
            type = (JType)((Object)arrays.get(key));
            value = JSONUtil.getValue(object, key);
            sb.append("\"" + key + "\": [ ");
            if (type == JType.OBJECT_ARRAY) {
                String pathToHere = path + "/" + key;
                PathAndKey pak = pathInfo.get(pathToHere);
                if (pak == null) {
                    JSONArray array = (JSONArray)value;
                    int stop = array.length() - 1;
                    for (int i = 0; i < array.length(); ++i) {
                        JSONObject arrobj = (JSONObject)array.get(i);
                        this.orderObject(arrobj, sb, pathInfo, path + "/" + key);
                        if (i >= stop) continue;
                        sb.append(", ");
                    }
                } else {
                    TreeMap<String, JSONObject> sorted = this.sortObjectArray((JSONArray)value, pak.key(), pak.path());
                    Iterator<JSONObject> it = sorted.values().iterator();
                    while (it.hasNext()) {
                        JSONObject currObj = it.next();
                        this.orderObject(currObj, sb, pathInfo, path + "/" + key);
                        if (!it.hasNext()) continue;
                        sb.append(", ");
                    }
                }
            } else {
                JSONArray array = (JSONArray)value;
                int len = array.length() - 1;
                for (int i = 0; i < array.length(); ++i) {
                    Object arrVal = array.get(i);
                    JType vtype = this.categorize(arrVal);
                    switch (vtype) {
                        case BOOLEAN: 
                        case NUMBER: {
                            sb.append(arrVal.toString());
                        }
                        case NULL: {
                            sb.append("null");
                            break;
                        }
                        case STRING: {
                            sb.append("\"" + arrVal.toString() + "\"");
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Expecting primitive value at: " + path);
                        }
                    }
                    if (i >= len) continue;
                    sb.append(", ");
                }
            }
            sb.append(" ]");
            if (--leftToPrint <= 0) continue;
            sb.append(", ");
        }
        sb.append(" }");
    }

    private TreeMap<String, JSONObject> sortObjectArray(JSONArray array, String sortKey, String path) {
        TreeMap<String, JSONObject> rc = new TreeMap<String, JSONObject>();
        for (int i = 0; i < array.length(); ++i) {
            Object keyValue;
            Object obj = array.get(i);
            if (obj instanceof JSONObject) {
                keyValue = JSONUtil.getValue((JSONObject)obj, sortKey);
                if (keyValue == null) {
                    keyValue = "ZZZZZ";
                    DebugInfo.debug("No value for key: " + sortKey);
                }
            } else {
                throw new IllegalStateException("Non-object in array at: " + path);
            }
            rc.put(keyValue.toString(), (JSONObject)obj);
        }
        return rc;
    }

    private JType categorize(Object val) {
        JType rc = JType.NULL;
        if (val instanceof JSONObject) {
            rc = JType.OBJECT;
        } else if (val instanceof JSONArray) {
            Object obj;
            rc = JType.ARRAY;
            JSONArray array = (JSONArray)val;
            if (array.length() > 0 && (obj = array.get(0)) instanceof JSONObject) {
                rc = JType.OBJECT_ARRAY;
            }
        } else {
            rc = val instanceof String ? JType.STRING : (val instanceof Number ? JType.NUMBER : (val instanceof Boolean ? JType.BOOLEAN : JType.NULL));
        }
        return rc;
    }

    private static enum JType {
        OBJECT,
        OBJECT_ARRAY,
        ARRAY,
        NUMBER,
        STRING,
        BOOLEAN,
        NULL;

    }
}

