/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmu.util.json;

import java.util.Iterator;
import java.util.TreeSet;
import org.dmd.dmu.server.extended.DmuModule;
import org.dmd.dmu.server.extended.json.PayloadExample;
import org.dmd.dmu.util.json.DeepSortNode;
import org.json.JSONArray;
import org.json.JSONObject;

public class DeepSortAnalyzer {
    private TreeSet<String> possibleSortKeyNames = new TreeSet();

    public void addPossibleSortkey(String value) {
        this.possibleSortKeyNames.add(value);
    }

    public void analyze(DmuModule module) {
        Iterator<PayloadExample> it = module.getAllPayloadExample();
        while (it.hasNext()) {
            PayloadExample ex = it.next();
            this.analyze(module, ex.getName().getNameString());
        }
    }

    public void analyze(DmuModule module, String payloadName) {
        Iterator<PayloadExample> it = module.getAllPayloadExample();
        while (it.hasNext()) {
            PayloadExample ex = it.next();
            if (!ex.getName().getNameString().equals(payloadName)) continue;
            JSONObject exObj = new JSONObject(ex.getJsonPayload().replaceAll("\\\\n", "\\\n"));
            DeepSortNode root = new DeepSortNode(this.possibleSortKeyNames);
            this.descendObject(root, exObj);
            StringBuilder sb = new StringBuilder();
            sb.append("PayloadSortInfo\n");
            sb.append("name " + payloadName + "\n");
            root.pathAndKeys(sb);
            System.out.println("Payload type: " + ex.getName() + "\n");
            System.out.println(sb.toString() + "\n\n");
        }
    }

    private void descendObject(DeepSortNode parent, JSONObject object) {
        Iterator keys = object.keys();
        while (keys.hasNext()) {
            DeepSortNode node;
            String key = (String)keys.next();
            Object value = object.get(key);
            if (value instanceof JSONObject) {
                node = new DeepSortNode(parent, key, false, this.possibleSortKeyNames);
                this.descendObject(node, (JSONObject)value);
                continue;
            }
            if (value instanceof JSONArray) {
                node = new DeepSortNode(parent, key, true, this.possibleSortKeyNames);
                this.descendArray(node, (JSONArray)value);
                continue;
            }
            parent.addPrimitive(key);
        }
    }

    private void descendArray(DeepSortNode arrayNode, JSONArray array) {
        if (array.isEmpty()) {
            return;
        }
        if (array.get(0) instanceof JSONObject) {
            for (int i = 0; i < array.length(); ++i) {
                Object obj = array.get(i);
                if (!(obj instanceof JSONObject)) {
                    throw new IllegalStateException("Mix of objects and primitives/arrays in JSONArray");
                }
                arrayNode.arrayElement().addKeySignature((JSONObject)obj);
                this.descendObject(arrayNode.arrayElement(), (JSONObject)obj);
            }
        }
    }
}

