/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmu.util.json;

import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import org.dmd.dmc.types.IntegerVar;
import org.json.JSONObject;

public class DeepSortNode {
    private TreeSet<String> possibleSortKeyNames;
    private String path;
    private String key;
    private boolean isArray;
    private boolean isArrayElement;
    private TreeSet<String> primitives;
    private TreeMap<String, DeepSortNode> children;
    private TreeMap<String, IntegerVar> signatureDist;
    private DeepSortNode arrayElement;

    public DeepSortNode(TreeSet<String> possibleSortKeyNames) {
        this.path = "";
        this.key = null;
        this.isArray = false;
        this.possibleSortKeyNames = possibleSortKeyNames;
    }

    public DeepSortNode(DeepSortNode parent, String key, boolean isArray, TreeSet<String> possibleSortKeyNames) {
        this.path = parent.path + "/" + key;
        this.key = key;
        this.isArray = isArray;
        this.possibleSortKeyNames = possibleSortKeyNames;
        parent.addChild(this);
        if (isArray) {
            this.arrayElement = new DeepSortNode(this, possibleSortKeyNames);
        }
    }

    private DeepSortNode(DeepSortNode parent, TreeSet<String> possibleSortKeyNames) {
        this.path = parent.path + "[]";
        this.key = null;
        this.possibleSortKeyNames = possibleSortKeyNames;
        this.isArrayElement = true;
        this.signatureDist = new TreeMap();
    }

    public boolean isArray() {
        return this.isArray;
    }

    public DeepSortNode arrayElement() {
        return this.arrayElement;
    }

    public String path() {
        return this.path;
    }

    public void addKeySignature(JSONObject obj) {
        TreeSet<String> keySet = new TreeSet<String>();
        Iterator keys = obj.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            keySet.add(key);
        }
        StringBuilder sb = new StringBuilder();
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            sb.append((String)it.next());
            if (!it.hasNext()) continue;
            sb.append("--");
        }
        String sig = sb.toString();
        IntegerVar count = this.signatureDist.get(sig);
        if (count == null) {
            count = new IntegerVar();
            this.signatureDist.put(sig, count);
        }
        count.set(count.intValue() + 1);
    }

    private void addChild(DeepSortNode child) {
        if (this.children == null) {
            this.children = new TreeMap();
        }
        this.children.put(child.key, child);
    }

    public void addPrimitive(String key) {
        if (this.primitives == null) {
            this.primitives = new TreeSet();
        }
        this.primitives.add(key);
    }

    public void fullHierarchy(StringBuilder sb) {
        if (this.isArrayElement) {
            if (this.primitives != null) {
                TreeSet<String> suggestions = new TreeSet<String>();
                for (String key : this.primitives) {
                    for (String possible : this.possibleSortKeyNames) {
                        if (!key.contains(possible)) continue;
                        suggestions.add(key);
                    }
                }
                if (suggestions.size() > 0) {
                    sb.append(this.path + "  -- key suggestions: ");
                    for (String key : suggestions) {
                        sb.append(key + " ");
                    }
                    sb.append("   signatures: " + this.signatureDist.size());
                    sb.append("\n");
                } else {
                    sb.append(this.path + "  -- NO SUGGESTION -- all primitives: ");
                    for (String key : this.primitives) {
                        sb.append(key + " ");
                    }
                    sb.append("   signatures: " + this.signatureDist.size());
                    sb.append("\n");
                }
            } else {
                sb.append(this.path + "\n");
            }
        } else {
            sb.append(this.path + "\n");
        }
        if (this.children != null) {
            for (DeepSortNode child : this.children.values()) {
                child.fullHierarchy(sb);
            }
        }
        if (this.arrayElement != null) {
            this.arrayElement.fullHierarchy(sb);
        }
    }

    public void pathAndKeys(StringBuilder sb) {
        if (this.isArrayElement && this.primitives != null) {
            TreeSet<String> suggestions = new TreeSet<String>();
            for (String key : this.primitives) {
                for (String possible : this.possibleSortKeyNames) {
                    if (!key.contains(possible)) continue;
                    suggestions.add(key);
                }
            }
            if (suggestions.size() == 1) {
                sb.append("pathAndKeys " + this.path.replace("[]", "") + "    " + (String)suggestions.first() + "\n");
            } else if (suggestions.size() > 0) {
                sb.append("pathAndKeys " + this.path.replace("[]", "") + "    -- key suggestions: ");
                for (String key : suggestions) {
                    sb.append(key + " ");
                }
                sb.append("\n");
            } else {
                sb.append("pathAndKeys " + this.path.replace("[]", "") + "    -- NO SUGGESTION -- all primitives: ");
                for (String key : this.primitives) {
                    sb.append(key + " ");
                }
                sb.append("\n");
            }
        }
        if (this.children != null) {
            for (DeepSortNode child : this.children.values()) {
                child.pathAndKeys(sb);
            }
        }
        if (this.arrayElement != null) {
            this.arrayElement.pathAndKeys(sb);
        }
    }
}

