/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmu.util.json;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class PrettyJSON {
    private static PrettyJSON instance;

    private PrettyJSON() {
    }

    public String prettyPrint(JSONObject object, boolean primitivesFirst) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        this.prettyPrint(object, sb, "", "", primitivesFirst);
        sb.append("}");
        return sb.toString();
    }

    public String prettyPrint(JSONObject object, boolean primitivesFirst, String indentAll) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        this.prettyPrint(object, sb, indentAll, "", primitivesFirst);
        sb.append(indentAll + "}");
        return sb.toString();
    }

    private void prettyPrint(JSONObject object, StringBuilder sb, String allIndent, String indent, boolean primitivesFirst) {
        if (primitivesFirst) {
            this.primitivesFirst(object, sb, allIndent, indent, primitivesFirst);
        } else {
            this.byAllKeys(object, sb, allIndent, indent, primitivesFirst);
        }
    }

    private void byAllKeys(JSONObject object, StringBuilder sb, String allIndent, String indent, boolean primitivesFirst) {
        int longest = 0;
        TreeMap<Object, VContainer> sorted = new TreeMap<Object, VContainer>(Collator.getInstance(Locale.ENGLISH));
        Iterator keyit = object.keys();
        while (keyit.hasNext()) {
            Object value;
            String key = (String)keyit.next();
            if (key.toString().length() > longest) {
                longest = key.toString().length();
            }
            if ((value = object.get(key)) == null) continue;
            if (value instanceof JSONObject) {
                sorted.put(key.toString(), new VContainer(JType.OBJECT, key.toString(), value));
                continue;
            }
            if (value instanceof JSONArray) {
                sorted.put(key.toString(), new VContainer(JType.ARRAY, key.toString(), value));
                continue;
            }
            if (value instanceof String) {
                sorted.put(key.toString(), new VContainer(JType.PRIMITIVE, key.toString(), value));
                continue;
            }
            if (value instanceof Number) {
                sorted.put(key.toString(), new VContainer(JType.PRIMITIVE, key.toString(), value));
                continue;
            }
            if (!(value instanceof Boolean)) continue;
            sorted.put(key.toString(), new VContainer(JType.PRIMITIVE, key.toString(), value));
        }
        Iterator it = sorted.values().iterator();
        while (it.hasNext()) {
            VContainer vc = (VContainer)it.next();
            vc.prettyPrint(sb, allIndent, indent + "  ", it.hasNext(), longest, primitivesFirst);
        }
    }

    private void primitivesFirst(JSONObject object, StringBuilder sb, String allIndent, String indent, boolean primitivesFirst) {
        int longest = 0;
        TreeMap<Object, VContainer> primitives = new TreeMap<Object, VContainer>(Collator.getInstance(Locale.ENGLISH));
        TreeMap<Object, VContainer> arrays = new TreeMap<Object, VContainer>(Collator.getInstance(Locale.ENGLISH));
        TreeMap<Object, VContainer> objects = new TreeMap<Object, VContainer>(Collator.getInstance(Locale.ENGLISH));
        Iterator keyit = object.keys();
        while (keyit.hasNext()) {
            Iterator value;
            String key = (String)keyit.next();
            if (key.toString().length() > longest) {
                longest = key.toString().length();
            }
            if ((value = object.get(key)) == null) continue;
            if (value instanceof JSONObject) {
                objects.put(key.toString(), new VContainer(JType.OBJECT, key.toString(), value));
                continue;
            }
            if (value instanceof JSONArray) {
                arrays.put(key.toString(), new VContainer(JType.ARRAY, key.toString(), value));
                continue;
            }
            if (value instanceof String) {
                primitives.put(key.toString(), new VContainer(JType.PRIMITIVE, key.toString(), value));
                continue;
            }
            if (value instanceof Number) {
                primitives.put(key.toString(), new VContainer(JType.PRIMITIVE, key.toString(), value));
                continue;
            }
            if (!(value instanceof Boolean)) continue;
            primitives.put(key.toString(), new VContainer(JType.PRIMITIVE, key.toString(), value));
        }
        ArrayList<VContainer> allValues = new ArrayList<VContainer>();
        for (VContainer vc : primitives.values()) {
            allValues.add(vc);
        }
        for (VContainer vc : arrays.values()) {
            allValues.add(vc);
        }
        for (VContainer vc : objects.values()) {
            allValues.add(vc);
        }
        Iterator it = allValues.iterator();
        while (it.hasNext()) {
            VContainer vc;
            vc = (VContainer)it.next();
            vc.prettyPrint(sb, allIndent, indent + "  ", it.hasNext(), longest, primitivesFirst);
        }
    }

    public static PrettyJSON instance() {
        if (instance == null) {
            instance = new PrettyJSON();
        }
        return instance;
    }

    private static enum JType {
        PRIMITIVE,
        OBJECT,
        ARRAY;

    }

    class VContainer {
        JType type;
        String key;
        Object value;

        VContainer(JType type, String key, Object value) {
            this.type = type;
            this.key = key;
            this.value = value;
        }

        void prettyPrint(StringBuilder sb, String allIndent, String indent, boolean moreValues, int longestKey, boolean primitivesFirst) {
            switch (this.type) {
                case ARRAY: {
                    if (this.key == null) {
                        sb.append(allIndent + indent + " [\n");
                    } else {
                        sb.append(allIndent + indent + "\"" + this.key + "\": [\n");
                    }
                    ArrayList<VContainer> values = this.values();
                    Iterator<VContainer> it = values.iterator();
                    while (it.hasNext()) {
                        VContainer vc = it.next();
                        vc.prettyPrint(sb, allIndent, indent + "  ", it.hasNext(), longestKey, primitivesFirst);
                    }
                    sb.append(allIndent + indent + "]");
                    break;
                }
                case OBJECT: {
                    if (this.key == null) {
                        sb.append(allIndent + indent + "{\n");
                    } else {
                        sb.append(allIndent + indent + "\"" + this.key + "\": {\n");
                    }
                    instance.prettyPrint((JSONObject)this.value, sb, allIndent, indent, primitivesFirst);
                    sb.append(allIndent + indent + "}");
                    break;
                }
                case PRIMITIVE: {
                    if (this.key == null) {
                        sb.append(allIndent + indent + "\"" + this.value.toString() + "\"");
                        break;
                    }
                    sb.append(allIndent + indent + "\"" + this.key + "\": ");
                    this.padding(sb, this.key, longestKey);
                    if (this.value instanceof String) {
                        sb.append("\"" + this.value.toString() + "\"");
                        break;
                    }
                    sb.append("" + this.value.toString() + "");
                }
            }
            if (moreValues) {
                sb.append(",");
            }
            sb.append("\n");
        }

        void padding(StringBuilder sb, String key, int longestKey) {
            if (key.length() < longestKey) {
                for (int i = key.length(); i < longestKey; ++i) {
                    sb.append(" ");
                }
            }
        }

        ArrayList<VContainer> values() {
            ArrayList<VContainer> rc = new ArrayList<VContainer>();
            JSONArray array = (JSONArray)this.value;
            for (int i = 0; i < array.length(); ++i) {
                Object val = array.get(i);
                if (val == null) continue;
                if (val instanceof JSONObject) {
                    rc.add(new VContainer(JType.OBJECT, null, val));
                    continue;
                }
                if (val instanceof JSONArray) {
                    rc.add(new VContainer(JType.ARRAY, null, val));
                    continue;
                }
                if (val instanceof String) {
                    rc.add(new VContainer(JType.PRIMITIVE, null, val));
                    continue;
                }
                if (val instanceof Number) {
                    rc.add(new VContainer(JType.PRIMITIVE, null, val));
                    continue;
                }
                if (!(val instanceof Boolean)) continue;
                rc.add(new VContainer(JType.PRIMITIVE, null, val));
            }
            return rc;
        }
    }
}

