/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmv.server;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcCompactSchemaIF;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcOmni;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.DmcValueExceptionSet;
import org.dmd.dmc.rules.DmcRuleException;
import org.dmd.dmc.rules.DmcRuleExceptionSet;
import org.dmd.dmc.rules.DmcRuleManager;
import org.dmd.dmc.rules.DynamicInitIF;
import org.dmd.dmc.rules.RuleCollection;
import org.dmd.dmc.rules.RuleIF;
import org.dmd.dmc.rules.SourceInfo;
import org.dmd.dmc.util.DmcUncheckedObject;
import org.dmd.dms.ClassDefinition;
import org.dmd.dms.RuleDefinition;
import org.dmd.dms.SchemaDefinition;
import org.dmd.dms.SchemaManager;
import org.dmd.dms.generated.dmo.MetaDMSAG;
import org.dmd.dms.generated.dmo.RuleDataDMO;
import org.dmd.dms.generated.rulesdmo.AttributeValidationRuleCollection;
import org.dmd.dms.generated.rulesdmo.ObjectValidationRuleCollection;
import org.dmd.dms.util.DmoObjectFactory;
import org.dmd.util.ConsoleRuleTracer;
import org.dmd.util.exceptions.ResultException;

public class DmvDynamicRuleManager
extends DmcRuleManager {
    AttributeValidationRuleCollection attributeValidators;
    ObjectValidationRuleCollection objectValidators;
    ArrayList<RuleCollection<?>> ruleCollections = new ArrayList();
    TreeMap<String, DmcCompactSchemaIF> loadedSchemas = new TreeMap();

    public DmvDynamicRuleManager() {
        this.attributeValidators = new AttributeValidationRuleCollection();
        this.ruleCollections.add(this.attributeValidators);
        this.objectValidators = new ObjectValidationRuleCollection();
        this.ruleCollections.add(this.objectValidators);
    }

    public void loadRules(DmcCompactSchemaIF schema) {
        if (this.loadedSchemas.get(schema.getSchemaName()) == null) {
            for (RuleCollection<?> collection : this.ruleCollections) {
                collection.addRules(schema.getRules());
            }
            this.loadedSchemas.put(schema.getSchemaName(), schema);
        }
    }

    void addThisRule(RuleIF rule) {
        for (RuleCollection<?> collection : this.ruleCollections) {
            collection.addRule(rule);
        }
    }

    SourceInfo getSource(DmcUncheckedObject uco) {
        SourceInfo rc = null;
        String file = uco.getSV(MetaDMSAG.__file.name);
        String line = uco.getSV(MetaDMSAG.__lineNumber.name);
        rc = new SourceInfo(file, line);
        return rc;
    }

    public void loadAndCheckRules(SchemaManager sm, SchemaDefinition sd) throws DmcRuleExceptionSet, DmcNameClashException, DmcValueException {
        DmcRuleExceptionSet rc = null;
        DmoObjectFactory dmofactory = new DmoObjectFactory(sm);
        ArrayList<RuleDataDMO> allRuleData = new ArrayList<RuleDataDMO>();
        ArrayList<RuleIF> allRules = new ArrayList<RuleIF>();
        Iterator<SchemaDefinition> schemas = sm.getSchemas();
        if (schemas != null) {
            SchemaDefinition curr;
            while (schemas.hasNext()) {
                curr = schemas.next();
                Iterator<DmcUncheckedObject> iterator = curr.getParsedRules();
                if (iterator == null) continue;
                while (iterator.hasNext()) {
                    DmcRuleException ex;
                    DmcUncheckedObject uco = iterator.next();
                    ClassDefinition ruleDataCD = sm.cdef(uco.getConstructionClass());
                    RuleDefinition ruleDEF = ruleDataCD.getRuleDefinition();
                    RuleDataDMO ruledata = null;
                    SourceInfo source = this.getSource(uco);
                    try {
                        ruledata = (RuleDataDMO)dmofactory.createObject(uco);
                    }
                    catch (ClassNotFoundException cnf) {
                        URL[] urls;
                        StringBuffer sb = new StringBuffer();
                        sb.append(cnf.getMessage() + "\n\n");
                        sb.append("You probably need to augment the following classpath:\n");
                        ClassLoader cl = ClassLoader.getSystemClassLoader();
                        for (URL url : urls = ((URLClassLoader)cl).getURLs()) {
                            sb.append(url.getFile() + "\n");
                        }
                        sb.append("\nwith the classpath info for the missing class.");
                        DmcRuleException ex2 = new DmcRuleException(sb.toString(), null);
                        ex2.source(source);
                        if (rc == null) {
                            rc = new DmcRuleExceptionSet();
                        }
                        rc.add(ex2);
                        throw rc;
                    }
                    catch (DmcValueException dve) {
                        ex = new DmcRuleException(dve.getMessage(), null);
                        ex.source(source);
                        if (rc == null) {
                            rc = new DmcRuleExceptionSet();
                        }
                        rc.add(ex);
                    }
                    catch (ResultException rex) {
                        ex = new DmcRuleException(rex.getMessage(), null);
                        ex.source(source);
                        if (rc == null) {
                            rc = new DmcRuleExceptionSet();
                        }
                        rc.add(ex);
                    }
                    if (ruledata == null) continue;
                    try {
                        ruledata.resolveReferences(sm, sm);
                    }
                    catch (DmcValueExceptionSet ex3) {
                        System.err.println(ex3.toString() + "\nFile: " + ruledata.getFile() + "  Line: " + ruledata.getLineNumber());
                    }
                    try {
                        DynamicInitIF rule = (DynamicInitIF)((Object)ruleDEF.newRuleInstance());
                        rule.setRuleData(ruledata);
                        allRuleData.add(ruledata);
                        allRules.add((RuleIF)((Object)rule));
                    }
                    catch (Exception ex4) {
                        System.err.println(ex4.toString());
                    }
                }
            }
            DmcOmni.instance().reset();
            schemas = sm.getSchemas();
            while (schemas.hasNext()) {
                curr = schemas.next();
                DmcOmni.instance().addCompactSchema(curr.getCompactSchema());
            }
            for (RuleIF ruleIF : allRules) {
                this.addThisRule(ruleIF);
            }
            DmcOmni.instance().ruleTracer(new ConsoleRuleTracer());
            DmcOmni.instance().ruleTracing(false);
            for (RuleDataDMO ruleDataDMO : allRuleData) {
                SourceInfo source = new SourceInfo(ruleDataDMO.getFile(), ruleDataDMO.getLineNumber() + "", ruleDataDMO);
                try {
                    this.executeAttributeValidation(ruleDataDMO);
                    this.executeObjectValidation(ruleDataDMO);
                }
                catch (DmcRuleExceptionSet e) {
                    e.source(source);
                    if (rc == null) {
                        rc = e;
                        continue;
                    }
                    rc.add(e);
                }
            }
        }
        if (rc != null) {
            throw rc;
        }
    }

    public void executeAttributeValidation(DmcObject obj) throws DmcRuleExceptionSet {
        DmcRuleExceptionSet rc = null;
        Iterator<DmcAttribute<?>> attrs = obj.getAttributeIterator();
        while (attrs.hasNext()) {
            try {
                this.attributeValidators.execute(obj, attrs.next());
            }
            catch (DmcRuleExceptionSet e) {
                if (rc == null) {
                    rc = e;
                } else {
                    rc.add(e);
                }
                if (!rc.immediateHalt()) continue;
                break;
            }
        }
        if (rc != null) {
            throw rc;
        }
    }

    public void executeObjectValidation(DmcObject obj) throws DmcRuleExceptionSet {
        this.objectValidators.execute(obj);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (RuleCollection<?> rc : this.ruleCollections) {
            sb.append(rc.toString());
        }
        return sb.toString();
    }
}

