/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmv.shared;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcCompactSchemaIF;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcOmni;
import org.dmd.dmc.DmcUniqueNameResolverIF;
import org.dmd.dmc.rules.DmcRuleExceptionSet;
import org.dmd.dmc.rules.DmcRuleManager;
import org.dmd.dmc.rules.RuleCollection;
import org.dmd.dmc.util.DmcUncheckedObject;
import org.dmd.dmc.util.UcoDataStoreIF;
import org.dmd.dmc.util.UcoFeedbackIF;
import org.dmd.dms.generated.dmo.MetaDMSAG;
import org.dmd.dms.generated.rulesdmo.AttributeValidationRuleCollection;
import org.dmd.dms.generated.rulesdmo.AttributeValidationWithResolverRuleCollection;
import org.dmd.dms.generated.rulesdmo.InitializationRuleCollection;
import org.dmd.dms.generated.rulesdmo.ObjectValidationRuleCollection;
import org.dmd.dms.generated.rulesdmo.UCOAttributeAuditRuleCollection;
import org.dmd.dms.generated.rulesdmo.UCOAttributeNormalizationRuleCollection;
import org.dmd.dms.generated.rulesdmo.UCOMappingRuleCollection;
import org.dmd.dms.generated.rulesdmo.UCOObjectAuditRuleCollection;
import org.dmd.dms.generated.rulesdmo.UCOObjectNormalizationRuleCollection;
import org.dmd.dms.generated.rulesdmo.UCOValidationRuleCollection;
import org.dmd.dmv.shared.generated.dmo.DmvDMSAG;

public class DmvRuleManager
extends DmcRuleManager {
    AttributeValidationRuleCollection attributeValidators;
    ObjectValidationRuleCollection objectValidators;
    AttributeValidationWithResolverRuleCollection attributeValidatorsWithResolver;
    InitializationRuleCollection initializers;
    UCOValidationRuleCollection ucoObjectvalidators;
    UCOAttributeNormalizationRuleCollection ucoAttributeNormalizers;
    UCOObjectNormalizationRuleCollection ucoObjectNormalizers;
    UCOMappingRuleCollection ucoMappers;
    UCOAttributeAuditRuleCollection ucoAttributeAuditors;
    UCOObjectAuditRuleCollection ucoObjectAuditors;
    ArrayList<RuleCollection<?>> ruleCollections = new ArrayList();
    TreeMap<String, DmcCompactSchemaIF> loadedSchemas = new TreeMap();

    public DmvRuleManager() {
        this.attributeValidators = new AttributeValidationRuleCollection();
        this.ruleCollections.add(this.attributeValidators);
        this.attributeValidatorsWithResolver = new AttributeValidationWithResolverRuleCollection();
        this.ruleCollections.add(this.attributeValidatorsWithResolver);
        this.objectValidators = new ObjectValidationRuleCollection();
        this.ruleCollections.add(this.objectValidators);
        this.initializers = new InitializationRuleCollection();
        this.ruleCollections.add(this.initializers);
        this.ucoObjectvalidators = new UCOValidationRuleCollection();
        this.ruleCollections.add(this.ucoObjectvalidators);
        this.ucoAttributeNormalizers = new UCOAttributeNormalizationRuleCollection();
        this.ruleCollections.add(this.ucoAttributeNormalizers);
        this.ucoObjectNormalizers = new UCOObjectNormalizationRuleCollection();
        this.ruleCollections.add(this.ucoObjectNormalizers);
        this.ucoMappers = new UCOMappingRuleCollection();
        this.ruleCollections.add(this.ucoMappers);
        this.ucoAttributeAuditors = new UCOAttributeAuditRuleCollection();
        this.ruleCollections.add(this.ucoAttributeAuditors);
        this.ucoObjectAuditors = new UCOObjectAuditRuleCollection();
        this.ruleCollections.add(this.ucoObjectAuditors);
        this.loadRules(MetaDMSAG.instance());
        DmcOmni.instance().addCompactSchema(DmvDMSAG.instance());
        this.loadRules(DmvDMSAG.instance());
    }

    public void loadRules(DmcCompactSchemaIF schema) {
        if (this.loadedSchemas.get(schema.getSchemaName()) == null) {
            for (RuleCollection<?> collection : this.ruleCollections) {
                collection.addRules(schema.getRules());
            }
            this.loadedSchemas.put(schema.getSchemaName(), schema);
        }
    }

    public void executeAttributeValidation(DmcObject obj) throws DmcRuleExceptionSet {
        DmcRuleExceptionSet rc = null;
        Iterator<DmcAttribute<?>> attrs = obj.getAttributeIterator();
        while (attrs.hasNext()) {
            try {
                this.attributeValidators.execute(obj, attrs.next());
            }
            catch (DmcRuleExceptionSet e) {
                if (rc == null) {
                    rc = e;
                } else {
                    rc.add(e);
                }
                if (!rc.immediateHalt()) continue;
                break;
            }
        }
        if (rc != null) {
            throw rc;
        }
    }

    public void executeAttributeValidationWithResolver(DmcObject obj, DmcUniqueNameResolverIF resolver) throws DmcRuleExceptionSet {
        DmcRuleExceptionSet rc = null;
        Iterator<DmcAttribute<?>> attrs = obj.getAttributeIterator();
        while (attrs.hasNext()) {
            try {
                this.attributeValidatorsWithResolver.execute(obj, attrs.next(), resolver);
            }
            catch (DmcRuleExceptionSet e) {
                if (rc == null) {
                    rc = e;
                } else {
                    rc.add(e);
                }
                if (!rc.immediateHalt()) continue;
                break;
            }
        }
        if (rc != null) {
            throw rc;
        }
    }

    public void executeObjectValidation(DmcObject obj) throws DmcRuleExceptionSet {
        this.objectValidators.execute(obj);
    }

    public void executeInitializers(DmcObject obj) throws DmcRuleExceptionSet {
        this.initializers.execute(obj);
    }

    public void executeUCOValidators(DmcUncheckedObject uco) throws DmcRuleExceptionSet {
        this.ucoObjectvalidators.execute(uco);
    }

    public void executeUCOAttributeNormalizers(DmcUncheckedObject uco, String attributeName, UcoDataStoreIF in, UcoFeedbackIF listener) throws DmcRuleExceptionSet {
        this.ucoAttributeNormalizers.execute(uco, attributeName, in, listener);
    }

    public void executeUCOObjectNormalizers(DmcUncheckedObject uco, UcoDataStoreIF in, UcoFeedbackIF listener) throws DmcRuleExceptionSet {
        this.ucoObjectNormalizers.execute(uco, in, listener);
    }

    public void executeUCOMappers(DmcUncheckedObject uco, UcoDataStoreIF in, UcoDataStoreIF out, UcoFeedbackIF listener) throws DmcRuleExceptionSet {
        this.ucoMappers.execute(uco, in, out, listener);
    }

    public void executeUCOAttributeAuditors(DmcUncheckedObject uco, String attributeName, UcoDataStoreIF in, UcoDataStoreIF out, UcoFeedbackIF listener) throws DmcRuleExceptionSet {
        this.ucoAttributeAuditors.execute(uco, attributeName, in, out, listener);
    }

    public void executeUCOObjectAuditors(DmcUncheckedObject uco, String attributeName, UcoDataStoreIF in, UcoDataStoreIF out, UcoFeedbackIF listener) throws DmcRuleExceptionSet {
        this.ucoObjectAuditors.execute(uco, in, out, listener);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (RuleCollection<?> rc : this.ruleCollections) {
            sb.append(rc.toString());
        }
        return sb.toString();
    }
}

