/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmv.shared.extended.rulesdmo;

import java.util.Map;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfoRef;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.rules.DmcRuleException;
import org.dmd.dmc.rules.DmcRuleExceptionSet;
import org.dmd.dms.generated.enums.ClassTypeEnum;
import org.dmd.dmv.shared.generated.dmo.AllowedAttributesRuleDataDMO;
import org.dmd.dmv.shared.generated.rulesdmo.AllowedAttributesRuleBaseImpl;

public class AllowedAttributesRule
extends AllowedAttributesRuleBaseImpl {
    public AllowedAttributesRule() {
    }

    public AllowedAttributesRule(AllowedAttributesRuleDataDMO dmo) {
        super(dmo);
    }

    @Override
    public void execute(DmcObject obj) throws DmcRuleExceptionSet {
        DmcRuleExceptionSet exceptions = null;
        Map<Integer, DmcAttributeInfoRef> mai = obj.getConstructionClassInfo().getIdToAttr();
        if (mai != null) {
            for (DmcAttributeInfoRef air : mai.values()) {
                if (!air.mandatory || obj.get(air.info.id) != null) continue;
                if (exceptions == null) {
                    exceptions = new DmcRuleExceptionSet();
                }
                exceptions.add(new DmcRuleException("Mandatory attribute is missing: " + air.info.name, this));
            }
        }
        if (obj.getConstructionClassInfo().classType != ClassTypeEnum.EXTENSIBLE) {
            for (DmcAttribute<?> attr : obj.getAttributes().values()) {
                if (obj.allowsAttribute(attr.getAttributeInfo())) continue;
                if (exceptions == null) {
                    exceptions = new DmcRuleExceptionSet();
                }
                exceptions.add(new DmcRuleException("Attribute: " + attr.getName() + " is not valid for an object of class: " + obj.getConstructionClassName(), this));
            }
        }
        if (exceptions != null) {
            throw exceptions;
        }
    }
}

