/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmv.shared.extended.rulesdmo;

import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.rules.DmcRuleException;
import org.dmd.dmc.rules.DmcRuleExceptionSet;
import org.dmd.dmv.shared.generated.dmo.CardinalityRuleDataDMO;
import org.dmd.dmv.shared.generated.rulesdmo.CardinalityRuleBaseImpl;

public class CardinalityRule
extends CardinalityRuleBaseImpl {
    public CardinalityRule() {
    }

    public CardinalityRule(CardinalityRuleDataDMO dmo) {
        super(dmo);
    }

    @Override
    public void execute(DmcObject obj, DmcAttribute<?> attribute) throws DmcRuleExceptionSet {
        DmcRuleExceptionSet rc = null;
        if (this.ruleDMO.getCrMinimum() == null) {
            if ((double)attribute.getMVSize() > this.ruleDMO.getCrMaximum()) {
                rc = new DmcRuleExceptionSet();
                rc.add(new DmcRuleException(this.ruleDMO.getRuleTitle() + "\nThe " + attribute.getName() + " attribute has more than " + this.ruleDMO.getCrMaximum() + " values\n\nIn object:\n" + obj.toOIF(), this));
                throw rc;
            }
            return;
        }
        if (this.ruleDMO.getCrMaximum() == null) {
            if ((double)attribute.getMVSize() < this.ruleDMO.getCrMinimum()) {
                rc = new DmcRuleExceptionSet();
                rc.add(new DmcRuleException(this.ruleDMO.getRuleTitle() + "\nThe " + attribute.getName() + " attribute has less than " + this.ruleDMO.getCrMinimum() + " values\n\nIn object:\n" + obj.toOIF(), this));
                throw rc;
            }
            return;
        }
        if ((double)attribute.getMVSize() < this.ruleDMO.getCrMinimum() || (double)attribute.getMVSize() > this.ruleDMO.getCrMaximum()) {
            rc = new DmcRuleExceptionSet();
            rc.add(new DmcRuleException(this.ruleDMO.getRuleTitle() + "\nThe " + attribute.getName() + " attribute must have cardinality " + this.ruleDMO.getCrMinimum() + "-" + this.ruleDMO.getCrMaximum() + "\n\nIn object:\n" + obj.toOIF(), this));
        }
        if (rc != null) {
            throw rc;
        }
    }
}

