/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmv.shared.extended.rulesdmo;

import java.util.Iterator;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.rules.DmcRuleException;
import org.dmd.dmc.rules.DmcRuleExceptionSet;
import org.dmd.dmc.rules.SourceInfo;
import org.dmd.dms.generated.dmo.AttributeDefinitionDMO;
import org.dmd.dms.generated.dmo.DSDefinitionDMO;
import org.dmd.dms.generated.dmo.MetaDMSAG;
import org.dmd.dms.generated.dmo.TypeDefinitionDMO;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.generated.types.AttributeDefinitionREF;
import org.dmd.dms.generated.types.DmcTypeAttributeDefinitionREFSV;
import org.dmd.dms.generated.types.TypeDefinitionREF;
import org.dmd.dmv.shared.generated.dmo.ReferencedAttributeTypeRuleDataDMO;
import org.dmd.dmv.shared.generated.rulesdmo.ReferencedAttributeTypeRuleBaseImpl;

public class ReferencedAttributeTypeRule
extends ReferencedAttributeTypeRuleBaseImpl {
    public ReferencedAttributeTypeRule() {
    }

    public ReferencedAttributeTypeRule(ReferencedAttributeTypeRuleDataDMO dmo) {
        super(dmo);
    }

    @Override
    public void execute(DmcObject obj, DmcAttribute<?> attribute) throws DmcRuleExceptionSet {
        DmcRuleExceptionSet rc = null;
        if (attribute.getAttributeInfo().valueType == ValueTypeEnum.SINGLE) {
            DmcTypeAttributeDefinitionREFSV refsv = (DmcTypeAttributeDefinitionREFSV)attribute;
            AttributeDefinitionREF ref = refsv.getSV();
            try {
                this.checkReferencedAttribute(obj, attribute, ref);
            }
            catch (DmcRuleException e) {
                rc = new DmcRuleExceptionSet();
                rc.add(e);
            }
        } else {
            for (int i = 0; i < attribute.getMVSize(); ++i) {
                AttributeDefinitionREF ref = (AttributeDefinitionREF)attribute.getMVnth(i);
                try {
                    this.checkReferencedAttribute(obj, attribute, ref);
                    continue;
                }
                catch (DmcRuleException e) {
                    if (rc == null) {
                        rc = new DmcRuleExceptionSet();
                    }
                    rc.add(e);
                }
            }
        }
        if (rc != null) {
            throw rc;
        }
    }

    void checkReferencedAttribute(DmcObject obj, DmcAttribute<?> attribute, AttributeDefinitionREF ref) throws DmcRuleException {
        if (ref.getObject() == null) {
            return;
        }
        String testType = ((AttributeDefinitionDMO)ref.getObject()).getType().getObjectName().getNameString();
        if (((AttributeDefinitionDMO)ref.getObject()).getType().getObject() != null) {
            testType = ((TypeDefinitionDMO)((AttributeDefinitionDMO)ref.getObject()).getType().getObject()).getName().getNameString();
        }
        if (this.ruleDMO.get(MetaDMSAG.__valueType) != null && this.ruleDMO.getAllowedValueType() != ((AttributeDefinitionDMO)ref.getObject()).getValueType()) {
            DmcRuleException rex = new DmcRuleException(this.getRuleTitle() + "\nExpected valueType: " + (Object)((Object)this.ruleDMO.getAllowedValueType()) + " but " + ref.getObjectName() + " has valueType: " + (Object)((Object)((AttributeDefinitionDMO)ref.getObject()).getValueType()), this);
            if (obj instanceof DSDefinitionDMO) {
                DSDefinitionDMO def = (DSDefinitionDMO)obj;
                rex.source(new SourceInfo(def.getFile(), def.getLineNumber() + ""));
            }
            throw rex;
        }
        if (this.ruleDMO.getAllowedTypeSize() > 0) {
            boolean typeOkay = false;
            Iterator<TypeDefinitionREF> types = this.ruleDMO.getAllowedType();
            while (types.hasNext()) {
                TypeDefinitionREF type = types.next();
                if (!type.getObjectName().getNameString().equals(testType)) continue;
                typeOkay = true;
                break;
            }
            if (!typeOkay) {
                DmcRuleException rex = new DmcRuleException(this.getRuleTitle() + "\n" + ref.getObjectName() + " isn't one of the expected types, it's of type: " + testType, this);
                if (obj instanceof DSDefinitionDMO) {
                    DSDefinitionDMO def = (DSDefinitionDMO)obj;
                    rex.source(new SourceInfo(def.getFile(), def.getLineNumber() + ""));
                }
                throw rex;
            }
        }
    }
}

