/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmv.shared.extended.rulesdmo;

import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.rules.DmcRuleException;
import org.dmd.dmc.rules.DmcRuleExceptionSet;
import org.dmd.dmv.shared.generated.dmo.RelatedNumbersRuleDataDMO;
import org.dmd.dmv.shared.generated.rulesdmo.RelatedNumbersRuleBaseImpl;

public class RelatedNumbersRule
extends RelatedNumbersRuleBaseImpl {
    public RelatedNumbersRule() {
    }

    public RelatedNumbersRule(RelatedNumbersRuleDataDMO dmo) {
        super(dmo);
    }

    @Override
    public void execute(DmcObject obj) throws DmcRuleExceptionSet {
        DmcAttribute<?> lhs = obj.get(this.ruleDMO.getLhs().getObjectName().getNameString());
        DmcAttribute<?> rhs = obj.get(this.ruleDMO.getRhs().getObjectName().getNameString());
        if (lhs == null || rhs == null) {
            return;
        }
        if (lhs != null && rhs != null) {
            Double lv = null;
            Double rv = null;
            if (lhs.getSV() instanceof Double) {
                lv = (Double)lhs.getSV();
            } else if (lhs.getSV() instanceof Integer) {
                lv = ((Integer)lhs.getSV()).doubleValue();
            } else {
                throw new IllegalStateException("RelatedNumbersRule accepts only Double compatible values or Integer, not: " + lhs.getSV().getClass().getName());
            }
            if (rhs.getSV() instanceof Double) {
                rv = (Double)rhs.getSV();
            } else if (rhs.getSV() instanceof Integer) {
                rv = ((Integer)rhs.getSV()).doubleValue();
            } else {
                throw new IllegalStateException("RelatedNumbersRule accepts only Double compatible values or Integer, not: " + lhs.getSV().getClass().getName());
            }
            boolean okay = false;
            switch (this.ruleDMO.getNumericRelation()) {
                case EQUALS: {
                    if (lv != rv) break;
                    okay = true;
                    break;
                }
                case GT: {
                    if (!(lv > rv)) break;
                    okay = true;
                    break;
                }
                case GTE: {
                    if (!(lv >= rv)) break;
                    okay = true;
                    break;
                }
                case LT: {
                    if (!(lv < rv)) break;
                    okay = true;
                    break;
                }
                case LTE: {
                    if (!(lv <= rv)) break;
                    okay = true;
                    break;
                }
                case NE: {
                    if (lv == rv) break;
                    okay = true;
                }
            }
            if (!okay) {
                DmcRuleExceptionSet ex = new DmcRuleExceptionSet();
                ex.add(new DmcRuleException(this.getRuleTitle(), this));
                throw ex;
            }
        }
    }
}

