/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmv.shared.extended.rulesdmo;

import java.util.Iterator;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcNamedObjectREF;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.rules.DmcRuleException;
import org.dmd.dmc.rules.DmcRuleExceptionSet;
import org.dmd.dmc.rules.SourceInfo;
import org.dmd.dms.generated.dmo.MetaDMSAG;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.generated.types.ClassDefinitionREF;
import org.dmd.dmv.shared.generated.dmo.RestrictReferencesRuleDataDMO;
import org.dmd.dmv.shared.generated.rulesdmo.RestrictReferencesRuleBaseImpl;

public class RestrictReferencesRule
extends RestrictReferencesRuleBaseImpl {
    public RestrictReferencesRule() {
    }

    public RestrictReferencesRule(RestrictReferencesRuleDataDMO dmo) {
        super(dmo);
    }

    @Override
    public void execute(DmcObject obj, DmcAttribute<?> attribute) throws DmcRuleExceptionSet {
        DmcRuleExceptionSet rc = null;
        if (attribute.getAttributeInfo().valueType == ValueTypeEnum.SINGLE) {
            DmcNamedObjectREF ref = (DmcNamedObjectREF)attribute.getSV();
            if (!ref.isResolved()) {
                throw new IllegalStateException("You must resolve objects before applying the RestrictReferencesRule");
            }
            DmcObject refobj = (DmcObject)ref.getObject();
            try {
                this.checkReferencedObject(refobj);
            }
            catch (DmcRuleException e) {
                rc = new DmcRuleExceptionSet();
                rc.add(e);
            }
        } else {
            Iterator<?> it = attribute.getMV();
            while (it.hasNext()) {
                DmcNamedObjectREF ref = (DmcNamedObjectREF)it.next();
                if (!ref.isResolved()) {
                    throw new IllegalStateException("You must resolve objects before applying the RestrictReferencesRule");
                }
                DmcObject refobj = (DmcObject)ref.getObject();
                try {
                    this.checkReferencedObject(refobj);
                }
                catch (DmcRuleException e) {
                    if (rc == null) {
                        rc = new DmcRuleExceptionSet();
                    }
                    rc.add(e);
                }
            }
        }
        if (rc != null) {
            throw rc;
        }
    }

    void checkReferencedObject(DmcObject referencedObj) throws DmcRuleException {
        boolean okay = false;
        Iterator<ClassDefinitionREF> ait = this.ruleDMO.getAllowedReference();
        while (ait.hasNext()) {
            ClassDefinitionREF cdref = ait.next();
            if (!referencedObj.getConstructionClassName().equals(cdref.getClassInfo().name)) continue;
            okay = true;
            break;
        }
        if (!okay) {
            StringBuilder sb = new StringBuilder();
            ait = this.ruleDMO.getAllowedReference();
            while (ait.hasNext()) {
                ClassDefinitionREF cdref = ait.next();
                sb.append(cdref.getClassInfo().name);
                if (!ait.hasNext()) continue;
                sb.append(", ");
            }
            DmcRuleException rex = new DmcRuleException(this.getRuleTitle() + "\nThe " + this.ruleDMO.getApplyToAttribute().getObjectName() + " attribute in " + this.ruleDMO.getApplyToClass() + " must reference objects of these class(es): " + sb.toString() + "\nThe object being referenced is of type: " + referencedObj.getConstructionClassName(), this);
            DmcAttribute<?> file = referencedObj.get(MetaDMSAG.__file);
            DmcAttribute<?> line = referencedObj.get(MetaDMSAG.__lineNumber);
            if (file != null && line != null) {
                rex.source(new SourceInfo(file.toString(), line.toString()));
            }
            throw rex;
        }
    }
}

