/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmv.shared.extended.rulesdmo;

import java.util.Iterator;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.rules.DmcRuleException;
import org.dmd.dmc.rules.DmcRuleExceptionSet;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmv.shared.generated.dmo.StringSetRuleDataDMO;
import org.dmd.dmv.shared.generated.rulesdmo.StringSetRuleBaseImpl;

public class StringSetRule
extends StringSetRuleBaseImpl {
    public StringSetRule() {
    }

    public StringSetRule(StringSetRuleDataDMO dmo) {
        super(dmo);
    }

    @Override
    public void execute(DmcObject obj, DmcAttribute<?> attribute) throws DmcRuleExceptionSet {
        DmcRuleExceptionSet rc = null;
        if (attribute.getAttributeInfo().valueType == ValueTypeEnum.SINGLE) {
            try {
                this.checkValue((String)attribute.getSV());
            }
            catch (DmcRuleException ex) {
                if (rc == null) {
                    rc = new DmcRuleExceptionSet();
                }
                rc.add(ex);
            }
        } else {
            Iterator<?> it = attribute.getMV();
            while (it.hasNext()) {
                try {
                    this.checkValue((String)it.next());
                }
                catch (DmcRuleException ex) {
                    if (rc == null) {
                        rc = new DmcRuleExceptionSet();
                    }
                    rc.add(ex);
                }
            }
        }
        if (rc != null) {
            throw rc;
        }
    }

    void checkValue(String value) throws DmcRuleException {
        DmcRuleException rex = null;
        if (!this.ruleDMO.allowedStringContains(value)) {
            rex = this.ruleDMO.getApplyToClass() == null ? new DmcRuleException(this.getRuleTitle() + "\nThis is not an allowable value for the " + this.ruleDMO.getApplyToAttribute().getObjectName() + " attribute: " + value, this) : new DmcRuleException(this.getRuleTitle() + "\nThis is not an allowable value for the " + this.ruleDMO.getApplyToAttribute().getObjectName() + " attribute in the" + this.ruleDMO.getApplyToClass() + " class: " + value, this);
        }
        if (rex != null) {
            throw rex;
        }
    }
}

