/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmv.shared.extended.rulesdmo;

import java.util.Iterator;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.rules.DmcRuleException;
import org.dmd.dmc.rules.DmcRuleExceptionSet;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmv.shared.generated.dmo.ValueLengthRuleDataDMO;
import org.dmd.dmv.shared.generated.rulesdmo.ValueLengthRuleBaseImpl;

public class ValueLengthRule
extends ValueLengthRuleBaseImpl {
    public ValueLengthRule() {
    }

    public ValueLengthRule(ValueLengthRuleDataDMO dmo) {
        super(dmo);
    }

    @Override
    public void execute(DmcObject obj, DmcAttribute<?> attribute) throws DmcRuleExceptionSet {
        DmcRuleExceptionSet rc = null;
        if (this.ruleDMO.getMinLength() != null && this.ruleDMO.getMaxLength() != null) {
            int max = this.ruleDMO.getMaxLength();
            int min = this.ruleDMO.getMinLength();
            if (attribute.getAttributeInfo().valueType != ValueTypeEnum.SINGLE) {
                Iterator<?> it = attribute.getMV();
                while (it.hasNext()) {
                    Object value = it.next();
                    try {
                        this.checkMinimum(min, value.toString());
                        this.checkMaximum(max, value.toString());
                    }
                    catch (DmcRuleException e) {
                        if (rc == null) {
                            rc = new DmcRuleExceptionSet();
                        }
                        rc.add(e);
                    }
                }
            }
        } else if (this.ruleDMO.getMinLength() != null) {
            // empty if block
        }
        if (rc != null) {
            throw rc;
        }
    }

    void checkMinimum(int length, String value) throws DmcRuleException {
    }

    void checkMaximum(int length, String value) throws DmcRuleException {
    }
}

