/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmv.shared.generated.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.dmd.dmc.DmcEnumIF;

public enum NumericRelationEnum implements DmcEnumIF
{
    EQUALS(0, "Equals"),
    GT(1, "Greater than"),
    LT(2, "Less than"),
    NE(3, "Not equal"),
    GTE(4, "Greater than or equal to"),
    LTE(5, "Less than or equal to");

    private static final Map<Integer, NumericRelationEnum> lookup;
    private static final Map<String, NumericRelationEnum> lookupString;
    private int ival;
    private String dval;

    private NumericRelationEnum(int i, String d) {
        this.ival = i;
        this.dval = d;
    }

    public int intValue() {
        return this.ival;
    }

    @Override
    public String displayValue() {
        return this.dval;
    }

    public static NumericRelationEnum get(int code) {
        return lookup.get(code);
    }

    public static NumericRelationEnum get(String str) {
        return lookupString.get(str.toUpperCase());
    }

    static {
        lookup = new HashMap<Integer, NumericRelationEnum>();
        for (NumericRelationEnum s : EnumSet.allOf(NumericRelationEnum.class)) {
            lookup.put(s.intValue(), s);
        }
        lookupString = new HashMap<String, NumericRelationEnum>();
        for (NumericRelationEnum s : EnumSet.allOf(NumericRelationEnum.class)) {
            lookupString.put(s.name(), s);
        }
    }
}

