/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmv.shared.generated.types;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.RuleName;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmv.shared.generated.types.CheckAttributesBasedOnValueRuleDataREF;
import org.dmd.dmv.shared.generated.types.DmcTypeCheckAttributesBasedOnValueRuleDataREF;

public class DmcTypeCheckAttributesBasedOnValueRuleDataREFMAP
extends DmcTypeCheckAttributesBasedOnValueRuleDataREF
implements Serializable {
    private static final Iterator<CheckAttributesBasedOnValueRuleDataREF> emptyList = new HashMap().values().iterator();
    protected Map<RuleName, CheckAttributesBasedOnValueRuleDataREF> value;

    public DmcTypeCheckAttributesBasedOnValueRuleDataREFMAP() {
        this.value = null;
    }

    public DmcTypeCheckAttributesBasedOnValueRuleDataREFMAP(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<RuleName, CheckAttributesBasedOnValueRuleDataREF>() : new TreeMap<RuleName, CheckAttributesBasedOnValueRuleDataREF>();
    }

    public RuleName firstKey() {
        if (this.getAttributeInfo().valueType == ValueTypeEnum.TREEMAPPED) {
            if (this.value == null) {
                return null;
            }
            TreeMap map = (TreeMap)this.value;
            return (RuleName)map.firstKey();
        }
        throw new IllegalStateException("Attribute " + this.getAttributeInfo().name + " is HASHMAPPED and doesn't support firstKey()");
    }

    public DmcTypeCheckAttributesBasedOnValueRuleDataREFMAP getNew() {
        return new DmcTypeCheckAttributesBasedOnValueRuleDataREFMAP(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<CheckAttributesBasedOnValueRuleDataREF> cloneIt() {
        DmcTypeCheckAttributesBasedOnValueRuleDataREFMAP dmcTypeCheckAttributesBasedOnValueRuleDataREFMAP = this;
        synchronized (dmcTypeCheckAttributesBasedOnValueRuleDataREFMAP) {
            DmcTypeCheckAttributesBasedOnValueRuleDataREFMAP rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (CheckAttributesBasedOnValueRuleDataREF val : this.value.values()) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckAttributesBasedOnValueRuleDataREF add(Object v) throws DmcValueException {
        DmcTypeCheckAttributesBasedOnValueRuleDataREFMAP dmcTypeCheckAttributesBasedOnValueRuleDataREFMAP = this;
        synchronized (dmcTypeCheckAttributesBasedOnValueRuleDataREFMAP) {
            RuleName key;
            CheckAttributesBasedOnValueRuleDataREF oldval;
            CheckAttributesBasedOnValueRuleDataREF newval = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if ((oldval = this.value.put(key = (RuleName)newval.getKey(), newval)) != null && oldval.valuesAreEqual(newval)) {
                newval = null;
            }
            return newval;
        }
    }

    @Override
    public CheckAttributesBasedOnValueRuleDataREF del(Object key) {
        DmcTypeCheckAttributesBasedOnValueRuleDataREFMAP dmcTypeCheckAttributesBasedOnValueRuleDataREFMAP = this;
        synchronized (dmcTypeCheckAttributesBasedOnValueRuleDataREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof RuleName) {
                return this.value.remove(key);
            }
            throw new IllegalStateException("Incompatible key type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<CheckAttributesBasedOnValueRuleDataREF> getMV() {
        DmcTypeCheckAttributesBasedOnValueRuleDataREFMAP dmcTypeCheckAttributesBasedOnValueRuleDataREFMAP = this;
        synchronized (dmcTypeCheckAttributesBasedOnValueRuleDataREFMAP) {
            if (this.value == null) {
                return emptyList;
            }
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<RuleName, CheckAttributesBasedOnValueRuleDataREF>(this.value) : new TreeMap<RuleName, CheckAttributesBasedOnValueRuleDataREF>(this.value);
            return clone.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<RuleName, CheckAttributesBasedOnValueRuleDataREF> getMVCopy() {
        DmcTypeCheckAttributesBasedOnValueRuleDataREFMAP dmcTypeCheckAttributesBasedOnValueRuleDataREFMAP = this;
        synchronized (dmcTypeCheckAttributesBasedOnValueRuleDataREFMAP) {
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? (this.value == null ? new HashMap() : new HashMap<RuleName, CheckAttributesBasedOnValueRuleDataREF>(this.value)) : (this.value == null ? new TreeMap() : new TreeMap<RuleName, CheckAttributesBasedOnValueRuleDataREF>(this.value));
            return clone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeCheckAttributesBasedOnValueRuleDataREFMAP dmcTypeCheckAttributesBasedOnValueRuleDataREFMAP = this;
        synchronized (dmcTypeCheckAttributesBasedOnValueRuleDataREFMAP) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    @Override
    public CheckAttributesBasedOnValueRuleDataREF getByKey(Object key) {
        DmcTypeCheckAttributesBasedOnValueRuleDataREFMAP dmcTypeCheckAttributesBasedOnValueRuleDataREFMAP = this;
        synchronized (dmcTypeCheckAttributesBasedOnValueRuleDataREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof RuleName) {
                return this.value.get((RuleName)key);
            }
            throw new IllegalStateException("Incompatible type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeCheckAttributesBasedOnValueRuleDataREFMAP dmcTypeCheckAttributesBasedOnValueRuleDataREFMAP = this;
        synchronized (dmcTypeCheckAttributesBasedOnValueRuleDataREFMAP) {
            if (this.value == null) {
                return false;
            }
            try {
                CheckAttributesBasedOnValueRuleDataREF val = this.typeCheck(v);
                return this.value.containsValue(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        DmcTypeCheckAttributesBasedOnValueRuleDataREFMAP dmcTypeCheckAttributesBasedOnValueRuleDataREFMAP = this;
        synchronized (dmcTypeCheckAttributesBasedOnValueRuleDataREFMAP) {
            if (this.value == null) {
                return false;
            }
            if (key instanceof RuleName) {
                return this.value.containsKey(key);
            }
            return false;
        }
    }
}

