/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmv.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmv.shared.generated.types.CheckAttributesBasedOnValueRuleDataREF;
import org.dmd.dmv.shared.generated.types.DmcTypeCheckAttributesBasedOnValueRuleDataREF;

public class DmcTypeCheckAttributesBasedOnValueRuleDataREFSET
extends DmcTypeCheckAttributesBasedOnValueRuleDataREF
implements Serializable {
    private static final Iterator<CheckAttributesBasedOnValueRuleDataREF> emptyList = new HashSet().iterator();
    protected Set<CheckAttributesBasedOnValueRuleDataREF> value;

    public DmcTypeCheckAttributesBasedOnValueRuleDataREFSET() {
        this.value = null;
    }

    public DmcTypeCheckAttributesBasedOnValueRuleDataREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<CheckAttributesBasedOnValueRuleDataREF>() : new TreeSet<CheckAttributesBasedOnValueRuleDataREF>();
    }

    public DmcTypeCheckAttributesBasedOnValueRuleDataREFSET getNew() {
        return new DmcTypeCheckAttributesBasedOnValueRuleDataREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<CheckAttributesBasedOnValueRuleDataREF> cloneIt() {
        DmcTypeCheckAttributesBasedOnValueRuleDataREFSET dmcTypeCheckAttributesBasedOnValueRuleDataREFSET = this;
        synchronized (dmcTypeCheckAttributesBasedOnValueRuleDataREFSET) {
            DmcTypeCheckAttributesBasedOnValueRuleDataREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (CheckAttributesBasedOnValueRuleDataREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckAttributesBasedOnValueRuleDataREF add(Object v) throws DmcValueException {
        DmcTypeCheckAttributesBasedOnValueRuleDataREFSET dmcTypeCheckAttributesBasedOnValueRuleDataREFSET = this;
        synchronized (dmcTypeCheckAttributesBasedOnValueRuleDataREFSET) {
            CheckAttributesBasedOnValueRuleDataREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckAttributesBasedOnValueRuleDataREF del(Object v) {
        DmcTypeCheckAttributesBasedOnValueRuleDataREFSET dmcTypeCheckAttributesBasedOnValueRuleDataREFSET = this;
        synchronized (dmcTypeCheckAttributesBasedOnValueRuleDataREFSET) {
            CheckAttributesBasedOnValueRuleDataREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<CheckAttributesBasedOnValueRuleDataREF> getMV() {
        DmcTypeCheckAttributesBasedOnValueRuleDataREFSET dmcTypeCheckAttributesBasedOnValueRuleDataREFSET = this;
        synchronized (dmcTypeCheckAttributesBasedOnValueRuleDataREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<CheckAttributesBasedOnValueRuleDataREF>(this.value).iterator();
            }
            return new TreeSet<CheckAttributesBasedOnValueRuleDataREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CheckAttributesBasedOnValueRuleDataREF> getMVCopy() {
        DmcTypeCheckAttributesBasedOnValueRuleDataREFSET dmcTypeCheckAttributesBasedOnValueRuleDataREFSET = this;
        synchronized (dmcTypeCheckAttributesBasedOnValueRuleDataREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<CheckAttributesBasedOnValueRuleDataREF>();
                }
                return new HashSet<CheckAttributesBasedOnValueRuleDataREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<CheckAttributesBasedOnValueRuleDataREF>(this.value);
            }
            return new TreeSet<CheckAttributesBasedOnValueRuleDataREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeCheckAttributesBasedOnValueRuleDataREFSET dmcTypeCheckAttributesBasedOnValueRuleDataREFSET = this;
        synchronized (dmcTypeCheckAttributesBasedOnValueRuleDataREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeCheckAttributesBasedOnValueRuleDataREFSET dmcTypeCheckAttributesBasedOnValueRuleDataREFSET = this;
        synchronized (dmcTypeCheckAttributesBasedOnValueRuleDataREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                CheckAttributesBasedOnValueRuleDataREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

