/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmv.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmv.shared.generated.types.DmcTypeInitRuleDataREF;
import org.dmd.dmv.shared.generated.types.InitRuleDataREF;

public class DmcTypeInitRuleDataREFSET
extends DmcTypeInitRuleDataREF
implements Serializable {
    private static final Iterator<InitRuleDataREF> emptyList = new HashSet().iterator();
    protected Set<InitRuleDataREF> value;

    public DmcTypeInitRuleDataREFSET() {
        this.value = null;
    }

    public DmcTypeInitRuleDataREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<InitRuleDataREF>() : new TreeSet<InitRuleDataREF>();
    }

    public DmcTypeInitRuleDataREFSET getNew() {
        return new DmcTypeInitRuleDataREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<InitRuleDataREF> cloneIt() {
        DmcTypeInitRuleDataREFSET dmcTypeInitRuleDataREFSET = this;
        synchronized (dmcTypeInitRuleDataREFSET) {
            DmcTypeInitRuleDataREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (InitRuleDataREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InitRuleDataREF add(Object v) throws DmcValueException {
        DmcTypeInitRuleDataREFSET dmcTypeInitRuleDataREFSET = this;
        synchronized (dmcTypeInitRuleDataREFSET) {
            InitRuleDataREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InitRuleDataREF del(Object v) {
        DmcTypeInitRuleDataREFSET dmcTypeInitRuleDataREFSET = this;
        synchronized (dmcTypeInitRuleDataREFSET) {
            InitRuleDataREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<InitRuleDataREF> getMV() {
        DmcTypeInitRuleDataREFSET dmcTypeInitRuleDataREFSET = this;
        synchronized (dmcTypeInitRuleDataREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<InitRuleDataREF>(this.value).iterator();
            }
            return new TreeSet<InitRuleDataREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<InitRuleDataREF> getMVCopy() {
        DmcTypeInitRuleDataREFSET dmcTypeInitRuleDataREFSET = this;
        synchronized (dmcTypeInitRuleDataREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<InitRuleDataREF>();
                }
                return new HashSet<InitRuleDataREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<InitRuleDataREF>(this.value);
            }
            return new TreeSet<InitRuleDataREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeInitRuleDataREFSET dmcTypeInitRuleDataREFSET = this;
        synchronized (dmcTypeInitRuleDataREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeInitRuleDataREFSET dmcTypeInitRuleDataREFSET = this;
        synchronized (dmcTypeInitRuleDataREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                InitRuleDataREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

