/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmv.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmv.shared.generated.types.DmcTypeNamedObjectRuleDataREF;
import org.dmd.dmv.shared.generated.types.NamedObjectRuleDataREF;

public class DmcTypeNamedObjectRuleDataREFSET
extends DmcTypeNamedObjectRuleDataREF
implements Serializable {
    private static final Iterator<NamedObjectRuleDataREF> emptyList = new HashSet().iterator();
    protected Set<NamedObjectRuleDataREF> value;

    public DmcTypeNamedObjectRuleDataREFSET() {
        this.value = null;
    }

    public DmcTypeNamedObjectRuleDataREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<NamedObjectRuleDataREF>() : new TreeSet<NamedObjectRuleDataREF>();
    }

    public DmcTypeNamedObjectRuleDataREFSET getNew() {
        return new DmcTypeNamedObjectRuleDataREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<NamedObjectRuleDataREF> cloneIt() {
        DmcTypeNamedObjectRuleDataREFSET dmcTypeNamedObjectRuleDataREFSET = this;
        synchronized (dmcTypeNamedObjectRuleDataREFSET) {
            DmcTypeNamedObjectRuleDataREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (NamedObjectRuleDataREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamedObjectRuleDataREF add(Object v) throws DmcValueException {
        DmcTypeNamedObjectRuleDataREFSET dmcTypeNamedObjectRuleDataREFSET = this;
        synchronized (dmcTypeNamedObjectRuleDataREFSET) {
            NamedObjectRuleDataREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamedObjectRuleDataREF del(Object v) {
        DmcTypeNamedObjectRuleDataREFSET dmcTypeNamedObjectRuleDataREFSET = this;
        synchronized (dmcTypeNamedObjectRuleDataREFSET) {
            NamedObjectRuleDataREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<NamedObjectRuleDataREF> getMV() {
        DmcTypeNamedObjectRuleDataREFSET dmcTypeNamedObjectRuleDataREFSET = this;
        synchronized (dmcTypeNamedObjectRuleDataREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<NamedObjectRuleDataREF>(this.value).iterator();
            }
            return new TreeSet<NamedObjectRuleDataREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<NamedObjectRuleDataREF> getMVCopy() {
        DmcTypeNamedObjectRuleDataREFSET dmcTypeNamedObjectRuleDataREFSET = this;
        synchronized (dmcTypeNamedObjectRuleDataREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<NamedObjectRuleDataREF>();
                }
                return new HashSet<NamedObjectRuleDataREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<NamedObjectRuleDataREF>(this.value);
            }
            return new TreeSet<NamedObjectRuleDataREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeNamedObjectRuleDataREFSET dmcTypeNamedObjectRuleDataREFSET = this;
        synchronized (dmcTypeNamedObjectRuleDataREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeNamedObjectRuleDataREFSET dmcTypeNamedObjectRuleDataREFSET = this;
        synchronized (dmcTypeNamedObjectRuleDataREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                NamedObjectRuleDataREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

