/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmv.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmv.shared.generated.types.DmcTypePartCheckerRuleDataREF;
import org.dmd.dmv.shared.generated.types.PartCheckerRuleDataREF;

public class DmcTypePartCheckerRuleDataREFSET
extends DmcTypePartCheckerRuleDataREF
implements Serializable {
    private static final Iterator<PartCheckerRuleDataREF> emptyList = new HashSet().iterator();
    protected Set<PartCheckerRuleDataREF> value;

    public DmcTypePartCheckerRuleDataREFSET() {
        this.value = null;
    }

    public DmcTypePartCheckerRuleDataREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<PartCheckerRuleDataREF>() : new TreeSet<PartCheckerRuleDataREF>();
    }

    public DmcTypePartCheckerRuleDataREFSET getNew() {
        return new DmcTypePartCheckerRuleDataREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<PartCheckerRuleDataREF> cloneIt() {
        DmcTypePartCheckerRuleDataREFSET dmcTypePartCheckerRuleDataREFSET = this;
        synchronized (dmcTypePartCheckerRuleDataREFSET) {
            DmcTypePartCheckerRuleDataREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (PartCheckerRuleDataREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartCheckerRuleDataREF add(Object v) throws DmcValueException {
        DmcTypePartCheckerRuleDataREFSET dmcTypePartCheckerRuleDataREFSET = this;
        synchronized (dmcTypePartCheckerRuleDataREFSET) {
            PartCheckerRuleDataREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartCheckerRuleDataREF del(Object v) {
        DmcTypePartCheckerRuleDataREFSET dmcTypePartCheckerRuleDataREFSET = this;
        synchronized (dmcTypePartCheckerRuleDataREFSET) {
            PartCheckerRuleDataREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<PartCheckerRuleDataREF> getMV() {
        DmcTypePartCheckerRuleDataREFSET dmcTypePartCheckerRuleDataREFSET = this;
        synchronized (dmcTypePartCheckerRuleDataREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<PartCheckerRuleDataREF>(this.value).iterator();
            }
            return new TreeSet<PartCheckerRuleDataREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PartCheckerRuleDataREF> getMVCopy() {
        DmcTypePartCheckerRuleDataREFSET dmcTypePartCheckerRuleDataREFSET = this;
        synchronized (dmcTypePartCheckerRuleDataREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<PartCheckerRuleDataREF>();
                }
                return new HashSet<PartCheckerRuleDataREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<PartCheckerRuleDataREF>(this.value);
            }
            return new TreeSet<PartCheckerRuleDataREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypePartCheckerRuleDataREFSET dmcTypePartCheckerRuleDataREFSET = this;
        synchronized (dmcTypePartCheckerRuleDataREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypePartCheckerRuleDataREFSET dmcTypePartCheckerRuleDataREFSET = this;
        synchronized (dmcTypePartCheckerRuleDataREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                PartCheckerRuleDataREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

