/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmv.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmv.shared.generated.types.DmcTypePatternMatchRuleDataREF;
import org.dmd.dmv.shared.generated.types.PatternMatchRuleDataREF;

public class DmcTypePatternMatchRuleDataREFSET
extends DmcTypePatternMatchRuleDataREF
implements Serializable {
    private static final Iterator<PatternMatchRuleDataREF> emptyList = new HashSet().iterator();
    protected Set<PatternMatchRuleDataREF> value;

    public DmcTypePatternMatchRuleDataREFSET() {
        this.value = null;
    }

    public DmcTypePatternMatchRuleDataREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<PatternMatchRuleDataREF>() : new TreeSet<PatternMatchRuleDataREF>();
    }

    public DmcTypePatternMatchRuleDataREFSET getNew() {
        return new DmcTypePatternMatchRuleDataREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<PatternMatchRuleDataREF> cloneIt() {
        DmcTypePatternMatchRuleDataREFSET dmcTypePatternMatchRuleDataREFSET = this;
        synchronized (dmcTypePatternMatchRuleDataREFSET) {
            DmcTypePatternMatchRuleDataREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (PatternMatchRuleDataREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PatternMatchRuleDataREF add(Object v) throws DmcValueException {
        DmcTypePatternMatchRuleDataREFSET dmcTypePatternMatchRuleDataREFSET = this;
        synchronized (dmcTypePatternMatchRuleDataREFSET) {
            PatternMatchRuleDataREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PatternMatchRuleDataREF del(Object v) {
        DmcTypePatternMatchRuleDataREFSET dmcTypePatternMatchRuleDataREFSET = this;
        synchronized (dmcTypePatternMatchRuleDataREFSET) {
            PatternMatchRuleDataREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<PatternMatchRuleDataREF> getMV() {
        DmcTypePatternMatchRuleDataREFSET dmcTypePatternMatchRuleDataREFSET = this;
        synchronized (dmcTypePatternMatchRuleDataREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<PatternMatchRuleDataREF>(this.value).iterator();
            }
            return new TreeSet<PatternMatchRuleDataREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PatternMatchRuleDataREF> getMVCopy() {
        DmcTypePatternMatchRuleDataREFSET dmcTypePatternMatchRuleDataREFSET = this;
        synchronized (dmcTypePatternMatchRuleDataREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<PatternMatchRuleDataREF>();
                }
                return new HashSet<PatternMatchRuleDataREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<PatternMatchRuleDataREF>(this.value);
            }
            return new TreeSet<PatternMatchRuleDataREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypePatternMatchRuleDataREFSET dmcTypePatternMatchRuleDataREFSET = this;
        synchronized (dmcTypePatternMatchRuleDataREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypePatternMatchRuleDataREFSET dmcTypePatternMatchRuleDataREFSET = this;
        synchronized (dmcTypePatternMatchRuleDataREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                PatternMatchRuleDataREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

