/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmv.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmv.shared.generated.types.DmcTypeStringSetRuleDataREF;
import org.dmd.dmv.shared.generated.types.StringSetRuleDataREF;

public class DmcTypeStringSetRuleDataREFSET
extends DmcTypeStringSetRuleDataREF
implements Serializable {
    private static final Iterator<StringSetRuleDataREF> emptyList = new HashSet().iterator();
    protected Set<StringSetRuleDataREF> value;

    public DmcTypeStringSetRuleDataREFSET() {
        this.value = null;
    }

    public DmcTypeStringSetRuleDataREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<StringSetRuleDataREF>() : new TreeSet<StringSetRuleDataREF>();
    }

    public DmcTypeStringSetRuleDataREFSET getNew() {
        return new DmcTypeStringSetRuleDataREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<StringSetRuleDataREF> cloneIt() {
        DmcTypeStringSetRuleDataREFSET dmcTypeStringSetRuleDataREFSET = this;
        synchronized (dmcTypeStringSetRuleDataREFSET) {
            DmcTypeStringSetRuleDataREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (StringSetRuleDataREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringSetRuleDataREF add(Object v) throws DmcValueException {
        DmcTypeStringSetRuleDataREFSET dmcTypeStringSetRuleDataREFSET = this;
        synchronized (dmcTypeStringSetRuleDataREFSET) {
            StringSetRuleDataREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringSetRuleDataREF del(Object v) {
        DmcTypeStringSetRuleDataREFSET dmcTypeStringSetRuleDataREFSET = this;
        synchronized (dmcTypeStringSetRuleDataREFSET) {
            StringSetRuleDataREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<StringSetRuleDataREF> getMV() {
        DmcTypeStringSetRuleDataREFSET dmcTypeStringSetRuleDataREFSET = this;
        synchronized (dmcTypeStringSetRuleDataREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<StringSetRuleDataREF>(this.value).iterator();
            }
            return new TreeSet<StringSetRuleDataREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<StringSetRuleDataREF> getMVCopy() {
        DmcTypeStringSetRuleDataREFSET dmcTypeStringSetRuleDataREFSET = this;
        synchronized (dmcTypeStringSetRuleDataREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<StringSetRuleDataREF>();
                }
                return new HashSet<StringSetRuleDataREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<StringSetRuleDataREF>(this.value);
            }
            return new TreeSet<StringSetRuleDataREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeStringSetRuleDataREFSET dmcTypeStringSetRuleDataREFSET = this;
        synchronized (dmcTypeStringSetRuleDataREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeStringSetRuleDataREFSET dmcTypeStringSetRuleDataREFSET = this;
        synchronized (dmcTypeStringSetRuleDataREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                StringSetRuleDataREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

