/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmw;

import java.util.HashMap;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcClassInfo;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.conversion.AttributeReadInterceptor;
import org.dmd.dmc.conversion.ObjectReadInterceptor;
import org.dmd.dms.ClassDefinition;
import org.dmd.dms.SchemaManager;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.generated.types.ClassDefinitionREF;
import org.dmd.dmw.DmwWrapper;

public class DmwDeserializer {
    SchemaManager schema;
    HashMap<DmcAttributeInfo, AttributeReadInterceptor> attrRI;
    HashMap<Integer, ClassSpecificInfo> classRI;
    HashMap<DmcClassInfo, ObjectReadInterceptor> objRI;

    public DmwDeserializer(SchemaManager s) {
        this.schema = s;
        this.attrRI = new HashMap();
        this.classRI = new HashMap();
        this.objRI = new HashMap();
    }

    public SchemaManager getSchema() {
        return this.schema;
    }

    public void addInterceptor(DmcAttributeInfo ai, AttributeReadInterceptor ari) {
        if (this.attrRI.containsKey(ai)) {
            throw new IllegalStateException("Duplicate interceptor for attribute: " + ai);
        }
        this.attrRI.put(ai, ari);
    }

    public void addInterceptor(DmcClassInfo dci, DmcAttributeInfo ai, AttributeReadInterceptor ari) {
        ClassSpecificInfo csi = this.classRI.get(dci.id);
        if (csi == null) {
            csi = new ClassSpecificInfo(dci);
        }
        csi.addInterceptor(ai, ari);
    }

    public void addInterceptor(DmcClassInfo dci, ObjectReadInterceptor ori) {
        if (this.objRI.containsKey(dci)) {
            throw new IllegalStateException("Duplicate interceptor for object class: " + dci);
        }
        this.objRI.put(dci, ori);
    }

    public DmwWrapper deserialize(DmcInputStreamIF dis) throws Exception {
        DmwWrapper rc = null;
        DmcObject dmo = null;
        int classCount = dis.readInt();
        int classID = dis.readInt();
        ClassDefinition cd = this.schema.isClass(classID);
        if (cd == null) {
            throw new IllegalStateException("Unknown class ID: " + classID + " ensure that you have loaded the required schemas.");
        }
        rc = cd.newInstance();
        dmo = rc.getDmcObject();
        if (classCount > 1) {
            for (int i = 1; i < classCount; ++i) {
                classID = dis.readInt();
                cd = this.schema.isClass(classID);
                dmo.addAux(new ClassDefinitionREF(cd.getDMO()));
            }
        }
        int attrCount = dis.readAttributeCount();
        for (int i = 0; i < attrCount; ++i) {
            DmcAttribute<?> attr = dis.getAttributeInstance();
            attr.deserializeIt(dis);
            if (attr.getAttributeInfo().valueType == ValueTypeEnum.SINGLE) {
                dmo.set(attr.getAttributeInfo(), attr);
                continue;
            }
            dmo.add(attr.getAttributeInfo(), attr);
        }
        return rc;
    }

    public DmwWrapper deserializeWithConversion(DmcInputStreamIF dis) throws Exception {
        DmwWrapper rc = null;
        DmcObject dmo = null;
        int classCount = dis.readInt();
        int classID = dis.readInt();
        ClassDefinition cd = this.schema.isClass(classID);
        if (cd == null) {
            throw new IllegalStateException("Unknown class ID: " + classID + " ensure that you have loaded the required schemas.");
        }
        rc = cd.newInstance();
        dmo = rc.getDmcObject();
        if (classCount > 1) {
            for (int i = 1; i < classCount; ++i) {
                classID = dis.readInt();
                cd = this.schema.isClass(classID);
                dmo.addAux(new ClassDefinitionREF(cd.getDMO()));
            }
        }
        int attrCount = dis.readAttributeCount();
        ClassSpecificInfo csi = this.classRI.get(dmo.getConstructionClassInfo().id);
        for (int i = 0; i < attrCount; ++i) {
            DmcAttribute<?> attr = dis.getAttributeInstance();
            AttributeReadInterceptor ari = this.attrRI.get(attr.getAttributeInfo());
            if (ari == null && csi != null) {
                ari = csi.getInterceptor(attr);
            }
            if (ari == null) {
                attr.deserializeIt(dis);
            } else {
                ari.handleAttribute(dis, attr);
            }
            if (attr.getAttributeInfo().valueType == ValueTypeEnum.SINGLE) {
                dmo.set(attr.getAttributeInfo(), attr);
                continue;
            }
            dmo.add(attr.getAttributeInfo(), attr);
        }
        ObjectReadInterceptor ori = this.objRI.get(dmo.getConstructionClassInfo());
        if (ori != null) {
            ori.handleObject(dmo);
        }
        return rc;
    }

    class ClassSpecificInfo {
        DmcClassInfo classInfo;
        HashMap<DmcAttributeInfo, AttributeReadInterceptor> attrRI;

        ClassSpecificInfo(DmcClassInfo dci) {
            this.classInfo = dci;
            this.attrRI = new HashMap();
        }

        void addInterceptor(DmcAttributeInfo ai, AttributeReadInterceptor ari) {
            if (this.attrRI.containsKey(ai)) {
                throw new IllegalStateException("Duplicate interceptor for attribute: " + ai);
            }
            this.attrRI.put(ai, ari);
        }

        AttributeReadInterceptor getInterceptor(DmcAttribute<?> attr) {
            return this.attrRI.get(attr.getAttributeInfo());
        }
    }
}

