/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmw;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.dmd.dmc.DmcHierarchicObjectName;
import org.dmd.dmc.DmcObject;
import org.dmd.dms.ClassDefinition;
import org.dmd.dmw.DmwNamedObjectWrapper;

public abstract class DmwHierarchicObjectWrapper
extends DmwNamedObjectWrapper {
    private WeakReference<DmwHierarchicObjectWrapper> parentRef = null;
    private TreeMap<DmcHierarchicObjectName, WeakReference<DmwHierarchicObjectWrapper>> childRefs = null;

    protected DmwHierarchicObjectWrapper() {
    }

    protected DmwHierarchicObjectWrapper(DmcObject obj) {
        super(obj);
    }

    protected DmwHierarchicObjectWrapper(DmcObject obj, ClassDefinition cd) {
        super(obj, cd);
    }

    @Override
    public abstract DmcHierarchicObjectName getObjectName();

    public DmcHierarchicObjectName getParentName() {
        return this.getObjectName().getParentName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DmwHierarchicObjectWrapper getParentComponent() {
        DmwHierarchicObjectWrapper dmwHierarchicObjectWrapper = this;
        synchronized (dmwHierarchicObjectWrapper) {
            if (this.parentRef == null) {
                return null;
            }
            DmwHierarchicObjectWrapper parent = (DmwHierarchicObjectWrapper)this.parentRef.get();
            if (parent == null) {
                this.parentRef = null;
            }
            return parent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DmwHierarchicObjectWrapper setParentComponent(DmwHierarchicObjectWrapper p) {
        DmwHierarchicObjectWrapper current = this.getParentComponent();
        DmwHierarchicObjectWrapper dmwHierarchicObjectWrapper = this;
        synchronized (dmwHierarchicObjectWrapper) {
            this.parentRef = new WeakReference<DmwHierarchicObjectWrapper>(p);
        }
        return current;
    }

    public DmwHierarchicObjectWrapper addSubComponent(DmwHierarchicObjectWrapper subcomp) {
        WeakReference<DmwHierarchicObjectWrapper> existing = null;
        if (this.childRefs == null) {
            this.childRefs = new TreeMap();
        }
        if ((existing = this.childRefs.put(subcomp.getObjectName(), new WeakReference<DmwHierarchicObjectWrapper>(subcomp))) == null) {
            return null;
        }
        return (DmwHierarchicObjectWrapper)existing.get();
    }

    public void removeSubcomponent(DmwHierarchicObjectWrapper subcomp) {
        if (this.childRefs == null) {
            throw new IllegalStateException("Tried to remove a subcomponent from an object with no subcomponents.");
        }
        this.childRefs.remove(subcomp.getObjectName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends DmwHierarchicObjectWrapper> E getChild(DmcHierarchicObjectName name) {
        DmwHierarchicObjectWrapper dmwHierarchicObjectWrapper = this;
        synchronized (dmwHierarchicObjectWrapper) {
            WeakReference<DmwHierarchicObjectWrapper> childRef = this.childRefs.get(name);
            if (childRef == null) {
                return null;
            }
            DmwHierarchicObjectWrapper child = (DmwHierarchicObjectWrapper)childRef.get();
            if (child == null) {
                this.childRefs.remove(name);
                return null;
            }
            return (E)child;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DmwHierarchicObjectWrapper> getSubComps() {
        DmwHierarchicObjectWrapper dmwHierarchicObjectWrapper = this;
        synchronized (dmwHierarchicObjectWrapper) {
            if (this.childRefs == null) {
                return Collections.emptyList();
            }
            LinkedList<DmwHierarchicObjectWrapper> children = new LinkedList<DmwHierarchicObjectWrapper>();
            LinkedList<DmcHierarchicObjectName> deadKeys = new LinkedList<DmcHierarchicObjectName>();
            for (Map.Entry<DmcHierarchicObjectName, WeakReference<DmwHierarchicObjectWrapper>> entry : this.childRefs.entrySet()) {
                DmwHierarchicObjectWrapper child = (DmwHierarchicObjectWrapper)entry.getValue().get();
                if (child == null) {
                    deadKeys.add(entry.getKey());
                    continue;
                }
                children.add(child);
            }
            for (DmcHierarchicObjectName deadKey : deadKeys) {
                this.childRefs.remove(deadKey);
            }
            return children;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends DmwHierarchicObjectWrapper> Collection<E> getSubComps(Class<E> clazz) {
        LinkedList<DmwHierarchicObjectWrapper> children = new LinkedList<DmwHierarchicObjectWrapper>();
        DmwHierarchicObjectWrapper dmwHierarchicObjectWrapper = this;
        synchronized (dmwHierarchicObjectWrapper) {
            if (this.childRefs == null) {
                return children;
            }
            LinkedList<DmcHierarchicObjectName> deadKeys = new LinkedList<DmcHierarchicObjectName>();
            for (Map.Entry<DmcHierarchicObjectName, WeakReference<DmwHierarchicObjectWrapper>> entry : this.childRefs.entrySet()) {
                DmwHierarchicObjectWrapper child = (DmwHierarchicObjectWrapper)entry.getValue().get();
                if (child == null) {
                    deadKeys.add(entry.getKey());
                    continue;
                }
                if (!child.getClass().equals(clazz)) continue;
                children.add(child);
            }
            for (DmcHierarchicObjectName deadKey : deadKeys) {
                this.childRefs.remove(deadKey);
            }
        }
        return children;
    }
}

