/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmw;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import org.dmd.dmc.DmcClassInfo;
import org.dmd.dmc.DmcObjectName;
import org.dmd.dmw.DmwNamedObjectWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmwNamedObjectIndexer {
    private HashMap<DmcClassInfo, HashMap<DmcObjectName, DmwNamedObjectWrapper>> indices;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public DmwNamedObjectIndexer() {
        this.indices = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasIndex(DmcClassInfo dci) {
        HashMap<DmcClassInfo, HashMap<DmcObjectName, DmwNamedObjectWrapper>> hashMap = this.indices;
        synchronized (hashMap) {
            HashMap<DmcObjectName, DmwNamedObjectWrapper> index = this.indices.get(dci);
            return index != null;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIndexSize(DmcClassInfo ci) {
        HashMap<DmcClassInfo, HashMap<DmcObjectName, DmwNamedObjectWrapper>> hashMap = this.indices;
        synchronized (hashMap) {
            HashMap<DmcObjectName, DmwNamedObjectWrapper> index = this.indices.get(ci);
            if (index == null) {
                return 0;
            }
            return index.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DmwNamedObjectWrapper> getIndex(DmcClassInfo ci) {
        HashMap<DmcClassInfo, HashMap<DmcObjectName, DmwNamedObjectWrapper>> hashMap = this.indices;
        synchronized (hashMap) {
            LinkedList<DmwNamedObjectWrapper> values = new LinkedList<DmwNamedObjectWrapper>();
            HashMap<DmcObjectName, DmwNamedObjectWrapper> index = this.indices.get(ci);
            if (index == null) {
                return Collections.EMPTY_LIST;
            }
            for (DmwNamedObjectWrapper value : index.values()) {
                values.add(value);
            }
            return values;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maintainIndex(DmcClassInfo ci) {
        HashMap<DmcObjectName, DmwNamedObjectWrapper> index = null;
        HashMap<DmcClassInfo, HashMap<DmcObjectName, DmwNamedObjectWrapper>> hashMap = this.indices;
        synchronized (hashMap) {
            index = this.indices.get(ci);
            if (index != null) {
                return;
            }
            index = new HashMap();
            this.indices.put(ci, index);
            this.logger.trace("Added indexing for class: " + ci.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToIndices(DmwNamedObjectWrapper obj) {
        HashMap<DmcClassInfo, HashMap<DmcObjectName, DmwNamedObjectWrapper>> hashMap = this.indices;
        synchronized (hashMap) {
            DmcClassInfo currentClass = obj.getConstructionClassInfo();
            HashMap<DmcObjectName, DmwNamedObjectWrapper> index = null;
            while (currentClass != null) {
                index = this.indices.get(currentClass);
                if (index != null) {
                    index.put(obj.getObjectName(), obj);
                    this.logger.trace("Object: " + obj.getObjectName().getNameString() + " added to index for class: " + currentClass.name);
                }
                currentClass = currentClass.derivedFrom;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFromIndices(DmwNamedObjectWrapper obj) {
        HashMap<DmcClassInfo, HashMap<DmcObjectName, DmwNamedObjectWrapper>> hashMap = this.indices;
        synchronized (hashMap) {
            DmcClassInfo currentClass = obj.getConstructionClassInfo();
            HashMap<DmcObjectName, DmwNamedObjectWrapper> index = null;
            while (currentClass != null) {
                index = this.indices.get(currentClass);
                if (index != null) {
                    index.remove(obj.getObjectName());
                    this.logger.trace("Object: " + obj.getObjectName().getNameString() + " removed from index for class: " + currentClass.name);
                }
                currentClass = currentClass.derivedFrom;
            }
        }
    }
}

