/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmw;

import java.util.Iterator;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DotName;
import org.dmd.dmc.util.DmcUncheckedObject;
import org.dmd.dmc.util.NamedStringArray;
import org.dmd.dms.AttributeDefinition;
import org.dmd.dms.ClassDefinition;
import org.dmd.dms.SchemaManager;
import org.dmd.dmw.DmwWrapper;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.exceptions.ResultException;

public class DmwObjectFactory {
    SchemaManager schema;

    public DmwObjectFactory(SchemaManager sm) {
        this.schema = sm;
    }

    public DmwWrapper createWrapper(DmcUncheckedObject uco) throws ResultException, DmcValueException, ClassNotFoundException, DmcNameClashException {
        DmwWrapper rc = null;
        DmcObject dmo = null;
        ClassDefinition cd = null;
        AttributeDefinition ad = null;
        cd = this.schema.isClass(uco.classes.get(0));
        if (cd == null) {
            DebugInfo.debug("UncheckedObject:\n\n" + uco.toOIF());
            ResultException ex = new ResultException();
            ex.result.addResult(3, "Unknown class: " + uco.classes.get(0));
            throw ex;
        }
        rc = cd.newInstance();
        dmo = rc.getDmcObject();
        for (int i = 1; i < uco.classes.size(); ++i) {
            cd = this.schema.isClass(uco.classes.get(i));
            if (cd == null) {
                DebugInfo.debug("UncheckedObject AUX:\n\n" + uco.toOIF());
                ResultException ex = new ResultException();
                ex.result.addResult(3, "Unknown class: " + uco.classes.get(i));
                throw ex;
            }
            rc.addAux(cd);
        }
        Iterator<String> names = uco.getAttributeNames();
        while (names.hasNext()) {
            String n = names.next();
            DmcAttributeInfo ai = dmo.getAttributeInfo(n);
            if (ai == null) {
                ResultException ex = new ResultException();
                ex.result.addResult(3, "Unknown attribute: " + n + " in object:\n\n" + uco.toOIF());
                throw ex;
            }
            DotName dn = new DotName(ai.qualifiedName, "AttributeDefinition");
            ad = this.schema.adef(dn);
            if (ad == null) {
                ResultException ex = new ResultException();
                ex.result.addResult(3, "Unknown attribute: " + n);
                throw ex;
            }
            NamedStringArray values = null;
            switch (ad.getValueType()) {
                case SINGLE: {
                    values = uco.get(n);
                    if (values.size() > 1) {
                        ResultException ex = new ResultException();
                        ex.result.addResult(3, "Multiple values for a single-valued attribute: " + n);
                        throw ex;
                    }
                    try {
                        DmcAttribute<?> attr = dmo.get(ad.getName().getNameString());
                        if (attr == null) {
                            attr = ad.getType().getAttributeHolder(ai);
                        }
                        attr.set(values.get(0));
                        dmo.set(ai, attr);
                        break;
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                        break;
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                        break;
                    }
                    catch (DmcValueException e) {
                        e.setAttributeName(ad.getName().getNameString());
                        throw e;
                    }
                }
                case MULTI: 
                case HASHMAPPED: 
                case TREEMAPPED: 
                case HASHSET: 
                case TREESET: {
                    values = uco.get(n);
                    for (String attrVal : values) {
                        try {
                            DmcAttribute<?> attr = dmo.get(ad.getName().getNameString());
                            if (attr == null) {
                                attr = ad.getType().getAttributeHolder(ai);
                            }
                            attr.add(attrVal);
                            dmo.add(ai, attr);
                        }
                        catch (InstantiationException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (DmcValueException e) {
                            throw e;
                        }
                    }
                    break;
                }
            }
        }
        return rc;
    }
}

