/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmw;

import java.util.ArrayList;
import java.util.Iterator;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcClassInfo;
import org.dmd.dmc.DmcContainer;
import org.dmd.dmc.DmcNameClashResolverIF;
import org.dmd.dmc.DmcNameResolverIF;
import org.dmd.dmc.DmcNameResolverWithClashSupportIF;
import org.dmd.dmc.DmcNamedObjectIF;
import org.dmd.dmc.DmcNamedObjectREF;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.DmcValueExceptionSet;
import org.dmd.dms.AttributeDefinition;
import org.dmd.dms.ClassDefinition;
import org.dmd.dms.SchemaManager;
import org.dmd.dms.generated.dmo.ClassDefinitionDMO;
import org.dmd.dms.generated.dmw.ClassDefinitionIterableDMW;
import org.dmd.dms.generated.types.ClassDefinitionREF;
import org.dmd.dms.generated.types.DmcTypeClassDefinitionREFMV;
import org.dmd.dms.generated.types.DmcTypeModifierMV;

public abstract class DmwWrapper
extends DmcContainer {
    protected DmwWrapper() {
    }

    protected DmwWrapper(DmcObject obj) {
        super(obj);
    }

    protected DmwWrapper(DmcObject obj, ClassDefinition cd) {
        super(obj);
        ClassDefinitionREF cdr;
        if (cd == null) {
            throw new IllegalStateException("The class definition for " + this.getClass().getName() + " has not been initialized. You must manage the associated schema.");
        }
        DmcObject dmo = obj;
        Iterator<ClassDefinitionREF> ocl = dmo.getObjectClass();
        if (ocl != null && (cdr = ocl.next()) != null) {
            cdr.setObject((ClassDefinitionDMO)cd.getDmcObject());
        }
    }

    public boolean applyModifier(DmcTypeModifierMV mods) throws DmcValueExceptionSet, DmcValueException {
        return this.getDmcObject().applyModifier(mods);
    }

    public boolean isReferenced() {
        return this.core.isReferenced();
    }

    public String getBackRefs() {
        return this.core.getBackRefs();
    }

    public int referenceCount() {
        return this.core.referenceCount();
    }

    public void youAreDeleted() {
        this.core.youAreDeleted();
    }

    public ArrayList<DmwWrapper> getReferringObjects() {
        ArrayList<DmwWrapper> rc = new ArrayList<DmwWrapper>();
        if (this.isReferenced()) {
            ArrayList<DmcObject> objlist = this.core.getReferringObjects();
            for (DmcObject obj : objlist) {
                rc.add((DmwWrapper)obj.getContainer());
            }
        }
        return rc;
    }

    public ArrayList<DmwWrapper> getReferringObjectsViaAttribute(DmcAttributeInfo ai) {
        ArrayList<DmwWrapper> rc = new ArrayList<DmwWrapper>();
        if (this.isReferenced()) {
            ArrayList<DmcObject> objlist = this.core.getReferringObjectsViaAttribute(ai);
            for (DmcObject obj : objlist) {
                rc.add((DmwWrapper)obj.getContainer());
            }
        }
        return rc;
    }

    public void serializeIt(DmcOutputStreamIF dos) throws Exception, DmcValueException {
        this.getDmcObject().serializeIt(dos);
    }

    public String getConstructionClassName() {
        if (this.getDmcObject() == null) {
            return null;
        }
        return this.getDmcObject().getConstructionClassName();
    }

    public ClassDefinitionIterableDMW getObjectClass() {
        DmcTypeClassDefinitionREFMV attr = (DmcTypeClassDefinitionREFMV)this.core.get(DmcObject.__objectClass);
        if (attr == null) {
            return ClassDefinitionIterableDMW.emptyList;
        }
        return new ClassDefinitionIterableDMW(attr.getMV());
    }

    public void addAux(ClassDefinition cd) throws DmcValueException {
        ClassDefinitionREF cdr = new ClassDefinitionREF(cd.getDMO());
        this.core.addAux(cdr);
    }

    public void removeAux(ClassDefinition cd) {
        this.core.removeAux(cd.getName().getNameString());
    }

    public boolean hasAux(ClassDefinition cd) {
        return this.core.hasAux(cd.getName().getNameString());
    }

    @Override
    public DmcObject getDmcObject() {
        return this.core;
    }

    @Override
    public void setDmcObject(DmcObject obj) {
        this.core = obj;
        obj.setContainer(this);
    }

    public ClassDefinition getConstructionClass() {
        ClassDefinitionREF cdr = this.core.getConstructionClass();
        if (cdr == null) {
            return null;
        }
        if (cdr.getObject() == null) {
            return null;
        }
        return (ClassDefinition)((ClassDefinitionDMO)cdr.getObject()).getContainer();
    }

    public DmcClassInfo getConstructionClassInfo() {
        if (this.core == null) {
            return null;
        }
        return this.core.getConstructionClassInfo();
    }

    public String toOIF() {
        return this.core.toOIF();
    }

    public String toPersistentOIF() {
        return this.core.toPersistentOIF();
    }

    public String toOIF(int padding) {
        return this.core.toOIF(padding);
    }

    public String toString() {
        return this.core.toOIF();
    }

    public String toJSON() {
        return this.core.toJSON();
    }

    public void resolveReferences(DmcNameResolverIF resolver) throws DmcValueExceptionSet {
        this.getDmcObject().resolveReferences(resolver);
    }

    public void resolveReferences(DmcNameResolverWithClashSupportIF rx, DmcNameClashResolverIF ncr) throws DmcValueExceptionSet {
        this.getDmcObject().resolveReferences(rx, ncr);
    }

    DmcNamedObjectIF resolve(SchemaManager sm, DmcNameResolverIF rx, AttributeDefinition ad, DmcNamedObjectREF obj) throws DmcValueException {
        DmcNamedObjectIF resolved = sm.findNamedObject(obj.getObjectName());
        if (resolved == null && rx != null) {
            resolved = rx.findNamedObject(obj.getObjectName());
        }
        if (resolved == null) {
            DmcValueException dve = new DmcValueException("Reference to object of type " + ad.getType().getObjectName() + " via attribute: " + ad.getName().getNameString() + " can't be found: " + obj.getObjectName());
            throw dve;
        }
        if (resolved instanceof DmwWrapper) {
            obj.setObject((DmcNamedObjectIF)((Object)((DmwWrapper)((Object)resolved)).getDmcObject()));
        } else {
            obj.setObject(resolved);
        }
        return resolved;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof DmwWrapper) {
            DmwWrapper other = (DmwWrapper)obj;
            return this.getDmcObject().equals(other.getDmcObject());
        }
        return false;
    }
}

